/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import org.jspecify.annotations.Nullable;

public class OtelTraceContextBuilder
implements TraceContext.Builder {
    private @Nullable String traceId;
    private @Nullable String parentId;
    private @Nullable String spanId;
    private @Nullable Boolean sampled;

    public TraceContext.Builder traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public TraceContext.Builder parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public TraceContext.Builder spanId(String spanId) {
        this.spanId = spanId;
        return this;
    }

    public TraceContext.Builder sampled(@Nullable Boolean sampled) {
        this.sampled = sampled;
        return this;
    }

    public TraceContext build() {
        boolean actualSampled;
        boolean bl = actualSampled = this.sampled != null && this.sampled != false;
        assert (this.traceId != null);
        assert (this.spanId != null);
        if (StringUtils.isNotEmpty((String)this.parentId)) {
            return new OtelTraceContext(SpanContext.createFromRemoteParent((String)this.traceId, (String)this.spanId, (TraceFlags)(actualSampled ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null){

                @Override
                public @Nullable String parentId() {
                    return OtelTraceContextBuilder.this.parentId;
                }

                @Override
                public @Nullable Boolean sampled() {
                    return OtelTraceContextBuilder.this.sampled;
                }
            };
        }
        return new OtelTraceContext(SpanContext.create((String)this.traceId, (String)this.spanId, (TraceFlags)(actualSampled ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null){

            @Override
            public @Nullable Boolean sampled() {
                return OtelTraceContextBuilder.this.sampled;
            }
        };
    }
}

