/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.SamplerFunction;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.http.HttpClientHandler;
import io.micrometer.tracing.http.HttpClientRequest;
import io.micrometer.tracing.http.HttpClientResponse;
import io.micrometer.tracing.http.HttpRequest;
import io.micrometer.tracing.http.HttpRequestParser;
import io.micrometer.tracing.http.HttpResponse;
import io.micrometer.tracing.http.HttpResponseParser;
import io.micrometer.tracing.otel.bridge.HttpRequestNetClientAttributesExtractor;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.PathAttributeExtractor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;

@Deprecated
public class OtelHttpClientHandler
implements HttpClientHandler {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OtelHttpClientHandler.class);
    private static final ContextKey<HttpClientRequest> REQUEST_CONTEXT_KEY = ContextKey.named((String)(OtelHttpClientHandler.class.getName() + ".request"));
    private final HttpRequestParser httpClientRequestParser;
    private final HttpResponseParser httpClientResponseParser;
    private final SamplerFunction<HttpRequest> samplerFunction;
    private final Instrumenter<HttpClientRequest, HttpClientResponse> instrumenter;

    @Deprecated
    public OtelHttpClientHandler(OpenTelemetry openTelemetry, @Nullable HttpRequestParser httpClientRequestParser, @Nullable HttpResponseParser httpClientResponseParser, SamplerFunction<HttpRequest> samplerFunction, HttpClientAttributesGetter<HttpClientRequest, HttpClientResponse> httpAttributesExtractor) {
        this(openTelemetry, httpClientRequestParser, httpClientResponseParser, samplerFunction, httpAttributesExtractor, new HttpRequestNetClientAttributesExtractor());
    }

    public OtelHttpClientHandler(OpenTelemetry openTelemetry, @Nullable HttpRequestParser httpClientRequestParser, @Nullable HttpResponseParser httpClientResponseParser, SamplerFunction<HttpRequest> samplerFunction, HttpClientAttributesGetter<HttpClientRequest, HttpClientResponse> httpAttributesExtractor, NetClientAttributesGetter<HttpClientRequest, HttpClientResponse> netAttributesGetter) {
        this.httpClientRequestParser = httpClientRequestParser;
        this.httpClientResponseParser = httpClientResponseParser;
        this.samplerFunction = samplerFunction;
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.micrometer.tracing", (SpanNameExtractor)HttpSpanNameExtractor.create(httpAttributesExtractor)).setSpanStatusExtractor(HttpSpanStatusExtractor.create(httpAttributesExtractor)).addAttributesExtractor(NetClientAttributesExtractor.create((NetClientAttributesGetter)new HttpRequestNetClientAttributesExtractor())).addAttributesExtractor(HttpClientAttributesExtractor.create(httpAttributesExtractor, netAttributesGetter)).addAttributesExtractor((AttributesExtractor)new PathAttributeExtractor()).buildClientInstrumenter(HttpClientRequest::header);
    }

    public Span handleSend(HttpClientRequest request) {
        Context parentContext = Context.current();
        return this.startSpan(request, parentContext);
    }

    public Span handleSend(HttpClientRequest request, TraceContext parent) {
        Context parentContext = OtelTraceContext.toOtelContext(parent);
        return this.startSpan(request, parentContext);
    }

    private Span startSpan(HttpClientRequest request, Context parentContext) {
        if (Boolean.FALSE.equals(this.samplerFunction.trySample((Object)request))) {
            if (log.isDebugEnabled()) {
                log.debug("Returning an invalid span since url [" + request.path() + "] is on a list of urls to skip");
            }
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context context = this.instrumenter.start(parentContext, (Object)request);
            return this.span(context, request);
        }
        return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
    }

    private Span span(Context context, HttpClientRequest request) {
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.fromContext((Context)context);
        Span result = OtelSpan.fromOtel(span, context.with(REQUEST_CONTEXT_KEY, (Object)request));
        if (this.httpClientRequestParser != null) {
            this.httpClientRequestParser.parse((HttpRequest)request, result.context(), (SpanCustomizer)result);
        }
        if (request.remotePort() != 0) {
            result.remoteIpAndPort(request.remoteIp(), request.remotePort());
        }
        return result;
    }

    public void handleReceive(HttpClientResponse response, Span span) {
        OtelSpan otelSpanWrapper = (OtelSpan)span;
        if (!otelSpanWrapper.delegate.getSpanContext().isValid()) {
            if (log.isDebugEnabled()) {
                log.debug("Not doing anything because the span is invalid");
            }
            return;
        }
        if (this.httpClientResponseParser != null) {
            this.httpClientResponseParser.parse((HttpResponse)response, span.context(), (SpanCustomizer)span);
        }
        OtelTraceContext traceContext = otelSpanWrapper.context();
        Context otelContext = traceContext.context();
        Context contextToEnd = Context.current().with((ImplicitContextKeyed)otelSpanWrapper.delegate);
        this.instrumenter.end(contextToEnd, (Object)((HttpClientRequest)otelContext.get(REQUEST_CONTEXT_KEY)), (Object)response, response.error());
    }
}

