/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import io.micrometer.tracing.otel.bridge.OtelFinishedSpan;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeSpanExporter
implements SpanExporter {
    private final Collection<SpanExporter> exporters;
    private final List<SpanExportingPredicate> predicates;
    private final List<SpanReporter> reporters;
    private final List<SpanFilter> spanFilters;

    public CompositeSpanExporter(Collection<SpanExporter> exporters, List<SpanExportingPredicate> predicates, List<SpanReporter> reporters, List<SpanFilter> spanFilters) {
        this.exporters = exporters;
        this.predicates = predicates == null ? Collections.emptyList() : predicates;
        this.reporters = reporters == null ? Collections.emptyList() : reporters;
        this.spanFilters = spanFilters == null ? Collections.emptyList() : spanFilters;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        List<SpanData> changedSpanData = spans.stream().filter(this::shouldProcess).map(spanData -> {
            FinishedSpan finishedSpan = OtelFinishedSpan.fromOtel(spanData);
            for (SpanFilter spanFilter : this.spanFilters) {
                finishedSpan = spanFilter.map(finishedSpan);
            }
            return OtelFinishedSpan.toOtel(finishedSpan);
        }).collect(Collectors.toList());
        if (changedSpanData.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList results = new ArrayList();
        changedSpanData.forEach(spanData -> this.reporters.forEach(reporter -> {
            try {
                reporter.report(OtelFinishedSpan.fromOtel(spanData));
                results.add(CompletableResultCode.ofSuccess());
            }
            catch (Exception ex) {
                results.add(CompletableResultCode.ofFailure());
            }
        }));
        this.exporters.forEach(spanExporter -> results.add(spanExporter.export((Collection)changedSpanData)));
        return CompletableResultCode.ofAll(results);
    }

    private boolean shouldProcess(SpanData span) {
        for (SpanExportingPredicate filter : this.predicates) {
            if (filter.isExportable(OtelFinishedSpan.fromOtel(span))) continue;
            return false;
        }
        return true;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofAll((Collection)this.exporters.stream().map(SpanExporter::flush).collect(Collectors.toList()));
    }

    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (SpanReporter reporter : this.reporters) {
            try {
                reporter.close();
                results.add(CompletableResultCode.ofSuccess());
            }
            catch (Exception ex) {
                results.add(CompletableResultCode.ofFailure());
            }
        }
        results.addAll(this.exporters.stream().map(SpanExporter::shutdown).collect(Collectors.toList()));
        return CompletableResultCode.ofAll(results);
    }
}

