/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.internal.baggage.BaggageFields;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.brave.bridge.BraveBaggageFields;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class W3CBaggagePropagator {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(W3CBaggagePropagator.class);
    private static final String TRACE_STATE = "tracestate";
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private final BaggageManager braveBaggageManager;
    private final List<String> localFields;

    W3CBaggagePropagator(BaggageManager baggageManager, List<String> localFields) {
        this.braveBaggageManager = baggageManager;
        this.localFields = localFields;
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            BaggageFields extra = (BaggageFields)context.findExtra(BaggageFields.class);
            if (extra == null || extra.getAllFields().isEmpty()) {
                return;
            }
            StringBuilder headerContent = new StringBuilder();
            String[] strings = this.localFields.toArray(new String[0]);
            Map filtered = extra.toMapFilteringFieldNames(strings);
            for (Map.Entry entry : filtered.entrySet()) {
                if (TRACE_STATE.equalsIgnoreCase((String)entry.getKey())) continue;
                headerContent.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                headerContent.append(",");
            }
            if (headerContent.length() > 0) {
                headerContent.setLength(headerContent.length() - 1);
                setter.put(carrier, (Object)FIELD, headerContent.toString());
            }
        };
    }

    <R> TraceContextOrSamplingFlags contextWithBaggage(R carrier, TraceContextOrSamplingFlags flags, Propagation.Getter<R, String> getter) {
        String baggageHeader = getter.get(carrier, (Object)FIELD);
        List<AbstractMap.SimpleEntry<Baggage, String>> pairs = baggageHeader == null || baggageHeader.isEmpty() ? Collections.emptyList() : this.addBaggageToContext(baggageHeader);
        return flags.toBuilder().addExtra((Object)new BraveBaggageFields(pairs)).build();
    }

    List<AbstractMap.SimpleEntry<Baggage, String>> addBaggageToContext(String baggageHeader) {
        String[] entries;
        ArrayList<AbstractMap.SimpleEntry<Baggage, String>> pairs = new ArrayList<AbstractMap.SimpleEntry<Baggage, String>>();
        for (String entry : entries = baggageHeader.split(",")) {
            Object[] keyAndValue;
            int beginningOfMetadata = entry.indexOf(";");
            if (beginningOfMetadata > 0) {
                entry = entry.substring(0, beginningOfMetadata);
            }
            if ((keyAndValue = entry.split("=")).length % 2 == 0) {
                for (int i = 0; i < keyAndValue.length - 1; i += 2) {
                    try {
                        String key = ((String)keyAndValue[i]).trim();
                        String value = ((String)keyAndValue[i + 1]).trim();
                        Baggage baggage = this.braveBaggageManager.createBaggage(key);
                        pairs.add(new AbstractMap.SimpleEntry<Baggage, String>(baggage, value));
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Exception occurred while trying to parse baggage with key value " + Arrays.toString(keyAndValue) + ". Will ignore that entry.", (Throwable)e);
                    }
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Unable to to parse baggage with key value since it seems something is not in key=value format: " + Arrays.toString(keyAndValue) + ". Will ignore that entry.");
        }
        return pairs;
    }
}

