/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public class BraveSpan
implements Span {
    final brave.Span delegate;

    public BraveSpan(brave.Span delegate) {
        this.delegate = delegate;
    }

    public static @Nullable brave.Span toBrave(@Nullable Span span) {
        BraveSpan braveSpan = (BraveSpan)span;
        if (braveSpan == null) {
            return null;
        }
        return braveSpan.delegate;
    }

    public static Span fromBrave(brave.Span span) {
        return new BraveSpan(span);
    }

    public boolean isNoop() {
        return this.delegate.isNoop();
    }

    public TraceContext context() {
        return new BraveTraceContext(this.delegate.context());
    }

    public Span start() {
        this.delegate.start();
        return this;
    }

    public Span name(String name) {
        this.delegate.name(name);
        return this;
    }

    public Span event(String value) {
        this.delegate.annotate(value);
        return this;
    }

    public Span event(String value, long time, TimeUnit timeUnit) {
        this.delegate.annotate(timeUnit.toMicros(time), value);
        return this;
    }

    public Span tag(String key, String value) {
        this.delegate.tag(key, value);
        return this;
    }

    public Span error(Throwable throwable) {
        String message = throwable.getMessage() == null ? throwable.getClass().getSimpleName() : throwable.getMessage();
        this.delegate.tag("error", message);
        this.delegate.error(throwable);
        return this;
    }

    public void end() {
        this.delegate.finish();
    }

    public void end(long time, TimeUnit timeUnit) {
        this.delegate.finish(timeUnit.toMicros(time));
    }

    public void abandon() {
        this.delegate.abandon();
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.remoteServiceName(remoteServiceName);
        return this;
    }

    public Span remoteIpAndPort(String ip, int port) {
        this.delegate.remoteIpAndPort(ip, port);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BraveSpan braveSpan = (BraveSpan)o;
        return Objects.equals(this.delegate, braveSpan.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

