/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Tracing;
import brave.internal.baggage.BaggageFields;
import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageFields;
import io.micrometer.tracing.brave.bridge.BraveSpanBuilder;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.propagation.Propagator;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class BravePropagator
implements Propagator {
    private final Tracing tracing;

    public BravePropagator(Tracing tracing) {
        this.tracing = tracing;
    }

    public List<String> fields() {
        return this.tracing.propagation().keys();
    }

    public <C> void inject(TraceContext traceContext, @Nullable C carrier, Propagator.Setter<C> setter) {
        this.tracing.propagation().injector((arg_0, arg_1, arg_2) -> setter.set(arg_0, arg_1, arg_2)).inject(BraveTraceContext.toBrave(traceContext), carrier);
    }

    public <C> Span.Builder extract(@Nullable C carrier, Propagator.Getter<C> getter) {
        TraceContextOrSamplingFlags extract = this.tracing.propagation().extractor((arg_0, arg_1) -> getter.get(arg_0, arg_1)).extract(carrier);
        this.updateExistingBaggageFieldsWithUpdatedValues(extract);
        return BraveSpanBuilder.toBuilder(this.tracing.tracer(), extract);
    }

    private void updateExistingBaggageFieldsWithUpdatedValues(TraceContextOrSamplingFlags extract) {
        if (extract.context() == null) {
            return;
        }
        List extra = extract.context().extra();
        extra.stream().filter(BraveBaggageFields.class::isInstance).forEach(o -> {
            BraveBaggageFields fields = (BraveBaggageFields)o;
            extra.stream().filter(BaggageFields.class::isInstance).forEach(bf -> {
                BaggageFields baggageFields = (BaggageFields)bf;
                List allFields = baggageFields.getAllFields();
                fields.getEntries().forEach(e -> {
                    String key = ((Baggage)e.getKey()).name();
                    String value = (String)e.getValue();
                    allFields.stream().filter(allField -> allField.name().equals(key)).forEach(allField -> allField.updateValue(extract, value));
                });
            });
        });
    }
}

