/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Span;
import brave.Tags;
import brave.baggage.BaggageField;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.util.List;
import org.jspecify.annotations.Nullable;

class BraveBaggageInScope
implements Baggage,
BaggageInScope {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BraveBaggageInScope.class);
    private final BaggageField delegate;
    private final @Nullable String previousBaggage;
    private final List<String> tagFields;
    private @Nullable brave.propagation.TraceContext traceContext;
    private final @Nullable Span span;

    BraveBaggageInScope(BaggageField delegate, @Nullable brave.propagation.TraceContext traceContext, @Nullable Span span, List<String> tagFields) {
        this.delegate = delegate;
        this.traceContext = traceContext;
        this.previousBaggage = traceContext != null ? delegate.getValue(traceContext) : delegate.getValue();
        this.tagFields = tagFields;
        this.span = span;
    }

    public String name() {
        return this.delegate.name();
    }

    public @Nullable String get() {
        return this.traceContext != null ? this.delegate.getValue(this.traceContext) : this.delegate.getValue();
    }

    public @Nullable String get(TraceContext traceContext) {
        return this.delegate.getValue(BraveTraceContext.toBrave(traceContext));
    }

    @Deprecated
    public Baggage set(@Nullable String value) {
        if (this.traceContext != null) {
            boolean success = this.delegate.updateValue(this.traceContext, value);
            if (logger.isTraceEnabled()) {
                logger.trace("Managed to update the baggage on set [" + success + "]. Provided value [" + value + "]");
            }
        } else {
            boolean success = this.delegate.updateValue(value);
            if (logger.isTraceEnabled()) {
                logger.trace("Managed to update the baggage on set [" + success + "]. Provided value [" + value + "]");
            }
        }
        this.tagSpanIfOnTagList();
        return this;
    }

    private void tagSpanIfOnTagList() {
        if (this.span != null) {
            this.tagFields.stream().filter(s -> s.equalsIgnoreCase(this.name())).findFirst().ifPresent(s -> Tags.BAGGAGE_FIELD.tag((Object)this.delegate, this.span));
        }
    }

    @Deprecated
    public Baggage set(TraceContext traceContext, @Nullable String value) {
        brave.propagation.TraceContext braveContext = this.updateBraveTraceContext(traceContext);
        boolean success = this.delegate.updateValue(braveContext, value);
        if (logger.isTraceEnabled()) {
            logger.trace("Managed to update the baggage on set [" + success + "]. Provided value [" + value + "], trace context [" + traceContext + "]");
        }
        this.tagSpanIfOnTagList();
        return this;
    }

    private @Nullable brave.propagation.TraceContext updateBraveTraceContext(TraceContext traceContext) {
        brave.propagation.TraceContext braveContext = BraveTraceContext.toBrave(traceContext);
        if (this.traceContext != braveContext) {
            logger.debug("Create on baggage was called on <{}> but now you want to set baggage on <{}>. That's unexpected.", (Object)this.traceContext, (Object)traceContext);
            this.traceContext = braveContext;
        }
        return braveContext;
    }

    public BaggageInScope makeCurrent() {
        return this;
    }

    public BaggageInScope makeCurrent(@Nullable String value) {
        if (this.traceContext != null) {
            boolean success = this.delegate.updateValue(this.traceContext, value);
            if (logger.isTraceEnabled()) {
                logger.trace("Managed to update the baggage on make current [" + success + "]");
            }
        } else {
            boolean success = this.delegate.updateValue(value);
            if (logger.isTraceEnabled()) {
                logger.trace("Managed to update the baggage on make current [" + success + "]");
            }
        }
        this.tagSpanIfOnTagList();
        return this.makeCurrent();
    }

    public BaggageInScope makeCurrent(TraceContext traceContext, @Nullable String value) {
        brave.propagation.TraceContext braveContext = this.updateBraveTraceContext(traceContext);
        boolean success = this.delegate.updateValue(braveContext, value);
        if (logger.isTraceEnabled()) {
            logger.trace("Managed to update the baggage on close [" + success + "]. Provided value [" + value + "], trace context [" + traceContext + "]");
        }
        this.tagSpanIfOnTagList();
        return this.makeCurrent();
    }

    public void close() {
        if (this.traceContext != null) {
            boolean success = this.delegate.updateValue(this.traceContext, this.previousBaggage);
            if (logger.isTraceEnabled()) {
                logger.trace("Managed to update the baggage on close [" + success + "]");
            }
        }
    }

    public String toString() {
        return "BraveBaggageInScope{delegate=" + this.delegate + ", previousBaggage='" + this.previousBaggage + '\'' + ", tagFields=" + this.tagFields + ", traceContext=" + this.traceContext + ", span=" + this.span + '}';
    }
}

