/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.baggage.BaggageField;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;

class BraveBaggageInScope
implements Baggage,
BaggageInScope {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BraveBaggageInScope.class);
    private final BaggageField delegate;
    private final String previousBaggage;
    @Nullable
    private brave.propagation.TraceContext traceContext;

    BraveBaggageInScope(BaggageField delegate, @Nullable brave.propagation.TraceContext traceContext) {
        this.delegate = delegate;
        this.traceContext = traceContext;
        this.previousBaggage = delegate.getValue();
    }

    public String name() {
        return this.delegate.name();
    }

    public String get() {
        return this.traceContext != null ? this.delegate.getValue(this.traceContext) : this.delegate.getValue();
    }

    public String get(TraceContext traceContext) {
        return this.delegate.getValue(BraveTraceContext.toBrave(traceContext));
    }

    @Deprecated
    public Baggage set(String value) {
        if (this.traceContext != null) {
            this.delegate.updateValue(this.traceContext, value);
        } else {
            this.delegate.updateValue(value);
        }
        return this;
    }

    @Deprecated
    public Baggage set(TraceContext traceContext, String value) {
        brave.propagation.TraceContext braveContext = this.updateBraveTraceContext(traceContext);
        this.delegate.updateValue(braveContext, value);
        return this;
    }

    private brave.propagation.TraceContext updateBraveTraceContext(TraceContext traceContext) {
        brave.propagation.TraceContext braveContext = BraveTraceContext.toBrave(traceContext);
        if (this.traceContext != braveContext) {
            logger.debug("Create on baggage was called on <{}> but now you want to set baggage on <{}>. That's unexpected.", (Object)this.traceContext, (Object)traceContext);
            this.traceContext = braveContext;
        }
        return braveContext;
    }

    public BaggageInScope makeCurrent() {
        return this;
    }

    public BaggageInScope makeCurrent(String value) {
        if (this.traceContext != null) {
            this.delegate.updateValue(this.traceContext, value);
        } else {
            this.delegate.updateValue(value);
        }
        return this.makeCurrent();
    }

    public BaggageInScope makeCurrent(TraceContext traceContext, String value) {
        brave.propagation.TraceContext braveContext = this.updateBraveTraceContext(traceContext);
        this.delegate.updateValue(braveContext, value);
        return this.makeCurrent();
    }

    public void close() {
        if (this.traceContext != null) {
            this.delegate.updateValue(this.traceContext, this.previousBaggage);
        }
    }
}

