/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.common.util.internal.logging;

import io.micrometer.common.util.internal.logging.InternalLogLevel;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class LogEvent {
    private final InternalLogLevel level;
    private final @Nullable String message;
    private final @Nullable Throwable cause;

    public LogEvent(InternalLogLevel level, @Nullable String message, @Nullable Throwable cause) {
        this.level = Objects.requireNonNull(level);
        this.message = message;
        this.cause = cause;
    }

    public InternalLogLevel getLevel() {
        return this.level;
    }

    public @Nullable String getMessage() {
        return this.message;
    }

    public @Nullable Throwable getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEvent)) {
            return false;
        }
        LogEvent logEvent = (LogEvent)o;
        return this.level == logEvent.level && Objects.equals(this.message, logEvent.message) && Objects.equals(this.cause, logEvent.cause);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.message, this.cause);
    }

    public String toString() {
        return "LogEvent{level=" + this.level + ", message='" + this.message + '\'' + ", cause=" + this.cause + '}';
    }
}

