/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.InstrumentationVerificationTests;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.docs.ObservationDocumentation;
import io.micrometer.observation.tck.TestObservationRegistry;
import io.micrometer.observation.tck.TestObservationRegistryAssert;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={InstrumentationVerificationTests.AfterBeforeParameterResolver.class})
abstract class InstrumentationTimingVerificationTests
extends InstrumentationVerificationTests {
    InstrumentationTimingVerificationTests() {
    }

    protected abstract String timerName();

    @Nullable
    protected ObservationDocumentation observationDocumentation() {
        return null;
    }

    @AfterEach
    void verifyObservationDocumentation(InstrumentationVerificationTests.TestType testType) {
        ObservationDocumentation observationDocumentation = this.observationDocumentation();
        if (observationDocumentation == null) {
            return;
        }
        Timer timer = this.getRegistry().get(this.timerName()).timer();
        Set<String> requiredDocumentedLowCardinalityKeys = this.getRequiredLowCardinalityKeyNames(observationDocumentation);
        HashSet<String> requiredTagKeys = new HashSet<String>(requiredDocumentedLowCardinalityKeys);
        if (testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER) {
            requiredTagKeys.add("error");
        }
        Set<String> allDocumentedLowCardinalityKeys = this.getLowCardinalityKeyNames(observationDocumentation);
        HashSet<String> allPossibleTagKeys = new HashSet<String>(allDocumentedLowCardinalityKeys);
        if (testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER) {
            allPossibleTagKeys.add("error");
        }
        Assertions.assertThat((List)timer.getId().getTags()).extracting(Tag::getKey).containsAll(requiredTagKeys);
        Assertions.assertThat((List)timer.getId().getTags()).extracting(Tag::getKey).isSubsetOf(allPossibleTagKeys);
        if (testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER) {
            if (observationDocumentation.getDefaultConvention() == null) {
                TestObservationRegistryAssert.assertThat((TestObservationRegistry)this.getObservationRegistry()).hasObservationWithNameEqualTo(observationDocumentation.getName()).that().hasContextualNameEqualTo(observationDocumentation.getContextualName());
            }
            TestObservationRegistryAssert.assertThat((TestObservationRegistry)this.getObservationRegistry()).hasObservationWithNameEqualTo(this.timerName()).that().hasSubsetOfKeys(this.getAllKeyNames(observationDocumentation));
        }
    }

    private Set<String> getRequiredLowCardinalityKeyNames(ObservationDocumentation observationDocumentation) {
        return Arrays.stream(observationDocumentation.getLowCardinalityKeyNames()).filter(KeyName::isRequired).map(KeyName::asString).collect(Collectors.toSet());
    }

    private Set<String> getLowCardinalityKeyNames(ObservationDocumentation observationDocumentation) {
        return Arrays.stream(observationDocumentation.getLowCardinalityKeyNames()).map(KeyName::asString).collect(Collectors.toSet());
    }

    private String[] getAllKeyNames(ObservationDocumentation observationDocumentation) {
        return (String[])Stream.concat(Arrays.stream(observationDocumentation.getLowCardinalityKeyNames()), Arrays.stream(observationDocumentation.getHighCardinalityKeyNames())).map(KeyName::asString).toArray(String[]::new);
    }
}

