/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

interface CounterTest {
    public Duration step();

    @DisplayName(value="multiple increments are maintained")
    @Test
    default public void increment(MeterRegistry registry) {
        Counter c = registry.counter("myCounter", new String[0]);
        c.increment();
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((double)c.count()).isEqualTo(1.0, Assertions.offset((Double)1.0E-12));
        c.increment();
        c.increment();
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((double)c.count()).isGreaterThanOrEqualTo(2.0);
    }

    @Test
    @DisplayName(value="increment by a non-negative amount")
    default public void incrementAmount(MeterRegistry registry) {
        Counter c = registry.counter("myCounter", new String[0]);
        c.increment(2.0);
        c.increment(0.0);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertEquals((double)2.0, (double)c.count());
    }

    @Test
    @DisplayName(value="function-tracking counter increments by change in a monotonically increasing function when observed")
    default public void functionTrackingCounter(MeterRegistry registry) {
        AtomicLong n = new AtomicLong(0L);
        registry.more().counter("tracking", Collections.emptyList(), (Number)n);
        n.incrementAndGet();
        MockClock.clock((MeterRegistry)registry).add(this.step());
        registry.forEachMeter(Meter::measure);
        Assertions.assertThat((double)registry.get("tracking").functionCounter().count()).isEqualTo(1.0);
    }
}

