/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.autoconfigure.OnlyOnceLoggingDenyMeterFilter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.web.client.DefaultRestTemplateExchangeTagsProvider;
import io.micrometer.spring.web.client.MetricsRestTemplateCustomizer;
import io.micrometer.spring.web.client.RestTemplateExchangeTagsProvider;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebClientAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, WebClientAutoConfiguration.class})
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate", "org.springframework.web.client.AsyncRestTemplate", "org.springframework.boot.web.client.RestTemplateCustomizer"})
@Conditional(value={RestTemplateMetricsConditionalOnBeans.class})
public class RestTemplateMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public RestTemplateMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplateExchangeTagsProvider.class})
    public DefaultRestTemplateExchangeTagsProvider restTemplateTagConfigurer() {
        return new DefaultRestTemplateExchangeTagsProvider();
    }

    @Bean
    public MetricsRestTemplateCustomizer metricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider restTemplateTagConfigurer) {
        return new MetricsRestTemplateCustomizer(meterRegistry, restTemplateTagConfigurer, this.properties.getWeb().getClient().getRequestsMetricName());
    }

    @Bean
    public SmartInitializingSingleton metricsAsyncRestTemplateInitializer(ObjectProvider<List<AsyncRestTemplate>> asyncRestTemplatesProvider, MetricsRestTemplateCustomizer customizer) {
        return () -> {
            List asyncRestTemplates = (List)asyncRestTemplatesProvider.getIfAvailable();
            if (!CollectionUtils.isEmpty((Collection)asyncRestTemplates)) {
                asyncRestTemplates.forEach(customizer::customize);
            }
        };
    }

    @Bean
    @Order(value=0)
    public MeterFilter metricsHttpClientUriTagFilter() {
        String metricName = this.properties.getWeb().getClient().getRequestsMetricName();
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'. Are you using 'uriVariables'?", metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.properties.getWeb().getClient().getMaxUriTags(), (MeterFilter)denyFilter);
    }

    static class RestTemplateMetricsConditionalOnBeans
    extends AllNestedConditions {
        RestTemplateMetricsConditionalOnBeans() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={RestTemplateBuilder.class})
        static class ConditionalOnRestTemplateBuilderBean {
            ConditionalOnRestTemplateBuilderBean() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class ConditionalOnMeterRegistryBean {
            ConditionalOnMeterRegistryBean() {
            }
        }
    }
}

