/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import ch.qos.logback.classic.LoggerContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class, LoggerContext.class, LoggerFactory.class})
@ConditionalOnBean(value={MeterRegistry.class})
@Conditional(value={LogbackLoggingCondition.class})
@ConditionalOnProperty(value={"management.metrics.binders.logback.enabled"}, matchIfMissing=true)
public class LogbackMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LogbackMetrics logbackMetrics() {
        return new LogbackMetrics();
    }

    static class LogbackLoggingCondition
    extends SpringBootCondition {
        LogbackLoggingCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"LogbackLoggingCondition", (Object[])new Object[0]);
            if (loggerFactory instanceof LoggerContext) {
                return ConditionOutcome.match((ConditionMessage)message.because("ILoggerFactory is a Logback LoggerContext"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("ILoggerFactory is an instance of " + loggerFactory.getClass().getCanonicalName()));
        }
    }
}

