/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.integration;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;

@NonNullApi
@NonNullFields
public class SpringIntegrationMetrics
implements MeterBinder,
SmartInitializingSingleton {
    private final Iterable<Tag> tags;
    private final IntegrationManagementConfigurer configurer;
    private Collection<MeterRegistry> registries = new ArrayList<MeterRegistry>();

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer) {
        this(configurer, Collections.emptyList());
    }

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer, Iterable<Tag> tags) {
        this.configurer = configurer;
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"spring.integration.channelNames", (Object)this.configurer, c -> c.getChannelNames().length).tags(this.tags).description("The number of spring integration channels").register(registry);
        Gauge.builder((String)"spring.integration.handlerNames", (Object)this.configurer, c -> c.getHandlerNames().length).tags(this.tags).description("The number of spring integration handlers").register(registry);
        Gauge.builder((String)"spring.integration.sourceNames", (Object)this.configurer, c -> c.getSourceNames().length).tags(this.tags).description("The number of spring integration sources").register(registry);
        this.registries.add(registry);
    }

    private void addSourceMetrics(MeterRegistry registry) {
        for (String source : this.configurer.getSourceNames()) {
            MessageSourceMetrics sourceMetrics = this.configurer.getSourceMetrics(source);
            Tags tagsWithSource = Tags.concat(this.tags, (String[])new String[]{"source", source});
            FunctionCounter.builder((String)"spring.integration.source.messages", (Object)sourceMetrics, MessageSourceMetrics::getMessageCount).tags((Iterable)tagsWithSource).description("The number of successful handler calls").register(registry);
        }
    }

    private void addHandlerMetrics(MeterRegistry registry) {
        for (String handler : this.configurer.getHandlerNames()) {
            MessageHandlerMetrics handlerMetrics = this.configurer.getHandlerMetrics(handler);
            Tags tagsWithHandler = Tags.concat(this.tags, (String[])new String[]{"handler", handler});
            TimeGauge.builder((String)"spring.integration.handler.duration.max", (Object)handlerMetrics, (TimeUnit)TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMaxDuration).tags((Iterable)tagsWithHandler).description("The maximum handler duration").register(registry);
            TimeGauge.builder((String)"spring.integration.handler.duration.min", (Object)handlerMetrics, (TimeUnit)TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMinDuration).tags((Iterable)tagsWithHandler).description("The minimum handler duration").register(registry);
            TimeGauge.builder((String)"spring.integration.handler.duration.mean", (Object)handlerMetrics, (TimeUnit)TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMeanDuration).tags((Iterable)tagsWithHandler).description("The mean handler duration").register(registry);
            Gauge.builder((String)"spring.integration.handler.activeCount", (Object)handlerMetrics, MessageHandlerMetrics::getActiveCount).tags((Iterable)tagsWithHandler).description("The number of active handlers").register(registry);
        }
    }

    private void addChannelMetrics(MeterRegistry registry) {
        for (String channel : this.configurer.getChannelNames()) {
            MessageChannelMetrics channelMetrics = this.configurer.getChannelMetrics(channel);
            Tags tagsWithChannel = Tags.concat(this.tags, (String[])new String[]{"channel", channel});
            FunctionCounter.builder((String)"spring.integration.channel.sendErrors", (Object)channelMetrics, MessageChannelMetrics::getSendErrorCount).tags((Iterable)tagsWithChannel).description("The number of failed sends (either throwing an exception or rejected by the channel)").register(registry);
            FunctionCounter.builder((String)"spring.integration.channel.sends", (Object)channelMetrics, MessageChannelMetrics::getSendCount).tags((Iterable)tagsWithChannel).description("The number of successful sends").register(registry);
            if (!(channelMetrics instanceof PollableChannelManagement)) continue;
            FunctionCounter.builder((String)"spring.integration.receives", (Object)((PollableChannelManagement)channelMetrics), PollableChannelManagement::getReceiveCount).tags((Iterable)tagsWithChannel).description("The number of messages received").register(registry);
        }
    }

    public void afterSingletonsInstantiated() {
        this.configurer.afterSingletonsInstantiated();
        this.registries.forEach(registry -> {
            this.addChannelMetrics((MeterRegistry)registry);
            this.addHandlerMetrics((MeterRegistry)registry);
            this.addSourceMetrics((MeterRegistry)registry);
        });
    }
}

