/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import java.util.Collection;
import java.util.Collections;

class MeterRegistryConfigurer {
    private final Collection<MeterRegistryCustomizer<?>> customizers;
    private final Collection<MeterFilter> filters;
    private final Collection<MeterBinder> binders;
    private final boolean addToGlobalRegistry;

    MeterRegistryConfigurer(Collection<MeterBinder> binders, Collection<MeterFilter> filters, Collection<MeterRegistryCustomizer<?>> customizers, boolean addToGlobalRegistry) {
        this.binders = binders != null ? binders : Collections.emptyList();
        this.filters = filters != null ? filters : Collections.emptyList();
        this.customizers = customizers != null ? customizers : Collections.emptyList();
        this.addToGlobalRegistry = addToGlobalRegistry;
    }

    void configure(MeterRegistry registry) {
        this.customize(registry);
        this.addFilters(registry);
        this.addBinders(registry);
        if (this.addToGlobalRegistry && registry != Metrics.globalRegistry) {
            Metrics.addRegistry((MeterRegistry)registry);
        }
    }

    private void customize(MeterRegistry registry) {
        for (MeterRegistryCustomizer<?> customizer : this.customizers) {
            try {
                customizer.customize(registry);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    private void addFilters(MeterRegistry registry) {
        this.filters.forEach(arg_0 -> ((MeterRegistry.Config)registry.config()).meterFilter(arg_0));
    }

    private void addBinders(MeterRegistry registry) {
        this.binders.forEach(binder -> binder.bindTo(registry));
    }
}

