/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

class WavefrontLongTaskTimer
extends DefaultLongTaskTimer {
    @Nullable
    private final WavefrontHistogramImpl histogram;

    WavefrontLongTaskTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, TimeUnit baseTimeUnit) {
        super(id, clock, baseTimeUnit, distributionStatisticConfig, false);
        this.histogram = distributionStatisticConfig.isPublishingHistogram() ? new WavefrontHistogramImpl(() -> ((Clock)clock).wallTime()) : null;
    }

    List<WavefrontHistogramImpl.Distribution> flushDistributions() {
        if (this.histogram == null) {
            return Collections.emptyList();
        }
        this.forEachActive(s -> this.histogram.update(s.duration(this.baseTimeUnit())));
        return this.histogram.flushDistributions();
    }

    boolean isPublishingHistogram() {
        return this.histogram != null;
    }
}

