/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.lang.Nullable;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class DatadogStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private static final String TYPE_DISTRIBUTION = "d";
    private static final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";
    private final Object conventionTagsLock = new Object();
    private volatile NamingConvention namingConvention;
    private volatile String name;
    @Nullable
    private volatile String conventionTags;
    private volatile String tagsNoStat;
    private final ConcurrentMap<Statistic, String> tags = new ConcurrentHashMap<Statistic, String>();
    private final boolean percentileHistogram;
    @Nullable
    String ddEntityId;

    public DatadogStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        this(id, config, null);
    }

    public DatadogStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config, @Nullable DistributionStatisticConfig distributionStatisticConfig) {
        super(id, config);
        this.percentileHistogram = distributionStatisticConfig != null && Boolean.TRUE.equals(distributionStatisticConfig.isPercentileHistogram());
        this.ddEntityId = System.getenv("DD_ENTITY_ID");
    }

    @Override
    public String timing(double timeMs) {
        if (this.percentileHistogram) {
            return this.distributionLine(timeMs);
        }
        return super.timing(timeMs);
    }

    @Override
    public String histogram(double amount) {
        if (this.percentileHistogram) {
            return this.distributionLine(amount);
        }
        return super.histogram(amount);
    }

    private String distributionLine(double amount) {
        return this.line(DoubleFormat.decimalOrNan((double)amount), null, TYPE_DISTRIBUTION);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + amount + "|" + type + this.tagsByStatistic(stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            Object object = this.conventionTagsLock;
            synchronized (object) {
                if (this.namingConvention == next) {
                    return;
                }
                this.tags.clear();
                String conventionTags = this.id.getTagsAsIterable().iterator().hasNext() ? this.id.getConventionTags(next).stream().map(this::formatTag).collect(Collectors.joining(",")) : null;
                this.conventionTags = this.appendEntityIdTag(conventionTags);
            }
            this.name = next.name(this.sanitizeName(this.id.getName()), this.id.getType(), this.id.getBaseUnit()) + ":";
            this.tagsNoStat = this.tags(null, this.conventionTags, ":", "|#");
            this.namingConvention = next;
        }
    }

    @Nullable
    private String appendEntityIdTag(@Nullable String tags) {
        if (this.ddEntityId != null && !this.ddEntityId.trim().isEmpty()) {
            String entityIdTag = this.formatTag(Tag.of((String)ENTITY_ID_TAG_NAME, (String)this.ddEntityId));
            return tags == null ? entityIdTag : tags + "," + entityIdTag;
        }
        return tags;
    }

    private String formatTag(Tag t) {
        String sanitizedTag = this.sanitizeName(t.getKey());
        if (!t.getValue().isEmpty()) {
            sanitizedTag = sanitizedTag + ":" + this.sanitizeTagValue(t.getValue());
        }
        return sanitizedTag;
    }

    private String sanitizeName(String value) {
        if (!Character.isLetter(value.charAt(0))) {
            value = "m." + value;
        }
        return value.replace(':', '_');
    }

    private String sanitizeTagValue(String value) {
        return value.charAt(value.length() - 1) == ':' ? value.substring(0, value.length() - 1) + '_' : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tagsByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            return this.tagsNoStat;
        }
        String tags = (String)this.tags.get(stat);
        if (tags != null) {
            return tags;
        }
        Object object = this.conventionTagsLock;
        synchronized (object) {
            return this.tags.computeIfAbsent(stat, key -> this.tags((Statistic)key, this.conventionTags, ":", "|#"));
        }
    }
}

