/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Disposables;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Sinks;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.transport.ClientTransport;
import io.micrometer.shaded.reactor.netty.udp.UdpClient;
import io.micrometer.shaded.reactor.util.retry.Retry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdCounter;
import io.micrometer.statsd.StatsdDistributionSummary;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdFunctionCounter;
import io.micrometer.statsd.StatsdFunctionTimer;
import io.micrometer.statsd.StatsdGauge;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdLongTaskTimer;
import io.micrometer.statsd.StatsdPollable;
import io.micrometer.statsd.StatsdProtocol;
import io.micrometer.statsd.StatsdTimer;
import io.micrometer.statsd.internal.BufferingFlux;
import io.micrometer.statsd.internal.DatadogStatsdLineBuilder;
import io.micrometer.statsd.internal.EtsyStatsdLineBuilder;
import io.micrometer.statsd.internal.LogbackMetricsSuppressingManySink;
import io.micrometer.statsd.internal.SysdigStatsdLineBuilder;
import io.micrometer.statsd.internal.TelegrafStatsdLineBuilder;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;

public class StatsdMeterRegistry
extends MeterRegistry {
    private static final WarnThenDebugLogger warnThenDebugLogger = new WarnThenDebugLogger(StatsdMeterRegistry.class);
    private final StatsdConfig statsdConfig;
    private final HierarchicalNameMapper nameMapper;
    private final Map<Meter.Id, StatsdPollable> pollableMeters = new ConcurrentHashMap<Meter.Id, StatsdPollable>();
    private final AtomicBoolean started = new AtomicBoolean();
    Sinks.Many<String> sink = new NoopManySink();
    Disposable.Swap statsdConnection = Disposables.swap();
    private Disposable.Swap meterPoller = Disposables.swap();
    @Nullable
    private BiFunction<Meter.Id, DistributionStatisticConfig, StatsdLineBuilder> lineBuilderFunction;
    @Nullable
    private Consumer<String> lineSink;
    private static final AttributeKey<Boolean> CONNECTION_DISPOSED = AttributeKey.valueOf("doOnDisconnectCalled");

    public StatsdMeterRegistry(StatsdConfig config, Clock clock) {
        this(config, HierarchicalNameMapper.DEFAULT, clock);
    }

    public StatsdMeterRegistry(StatsdConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        this(config, nameMapper, StatsdMeterRegistry.namingConventionFromFlavor(config.flavor()), clock, null, null);
    }

    private StatsdMeterRegistry(StatsdConfig config, HierarchicalNameMapper nameMapper, NamingConvention namingConvention, Clock clock, @Nullable BiFunction<Meter.Id, DistributionStatisticConfig, StatsdLineBuilder> lineBuilderFunction, @Nullable Consumer<String> lineSink) {
        super(clock);
        config.requireValid();
        this.statsdConfig = config;
        this.nameMapper = nameMapper;
        this.lineBuilderFunction = lineBuilderFunction;
        this.lineSink = lineSink;
        this.config().namingConvention(namingConvention);
        this.config().onMeterRemoved(meter -> meter.use(this::removePollableMeter, c -> ((StatsdCounter)((Object)((Object)c))).shutdown(), t -> ((StatsdTimer)((Object)((Object)t))).shutdown(), d -> ((StatsdDistributionSummary)((Object)((Object)d))).shutdown(), this::removePollableMeter, this::removePollableMeter, this::removePollableMeter, this::removePollableMeter, m -> {
            for (Measurement measurement : m.measure()) {
                this.pollableMeters.remove(m.getId().withTag(measurement.getStatistic()));
            }
        }));
        if (config.enabled()) {
            this.sink = Sinks.many().multicast().directBestEffort();
            try {
                Class.forName("ch.qos.logback.classic.turbo.TurboFilter", false, ((Object)((Object)this)).getClass().getClassLoader());
                this.sink = new LogbackMetricsSuppressingManySink(this.sink);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.start();
        }
    }

    public static Builder builder(StatsdConfig config) {
        return new Builder(config);
    }

    private static NamingConvention namingConventionFromFlavor(StatsdFlavor flavor) {
        switch (flavor) {
            case DATADOG: 
            case SYSDIG: {
                return NamingConvention.dot;
            }
            case TELEGRAF: {
                return NamingConvention.snakeCase;
            }
        }
        return NamingConvention.camelCase;
    }

    private <M extends Meter> void removePollableMeter(M m) {
        this.pollableMeters.remove(m.getId());
    }

    void poll() {
        for (Map.Entry<Meter.Id, StatsdPollable> pollableMeter : this.pollableMeters.entrySet()) {
            try {
                pollableMeter.getValue().poll();
            }
            catch (RuntimeException e) {
                warnThenDebugLogger.log("Failed to poll a meter '" + pollableMeter.getKey().getName() + "'.", (Throwable)e);
            }
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.lineSink != null) {
                this.sink.asFlux().subscribe(new Subscriber<String>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(String line) {
                        if (StatsdMeterRegistry.this.started.get()) {
                            StatsdMeterRegistry.this.lineSink.accept(line);
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                    }

                    @Override
                    public void onComplete() {
                        StatsdMeterRegistry.this.meterPoller.dispose();
                    }
                });
                this.startPolling();
            } else {
                Flux<String> publisher = this.statsdConfig.buffered() ? BufferingFlux.create(this.sink.asFlux(), "\n", this.statsdConfig.maxPacketLength(), this.statsdConfig.pollingFrequency().toMillis()).onBackpressureLatest() : this.sink.asFlux();
                if (this.statsdConfig.protocol() == StatsdProtocol.UDP) {
                    this.prepareUdpClient(publisher, () -> InetSocketAddress.createUnresolved(this.statsdConfig.host(), this.statsdConfig.port()));
                } else if (this.statsdConfig.protocol() == StatsdProtocol.UDS_DATAGRAM) {
                    this.prepareUdpClient(publisher, () -> new DomainSocketAddress(this.statsdConfig.host()));
                } else if (this.statsdConfig.protocol() == StatsdProtocol.TCP) {
                    this.prepareTcpClient(publisher);
                }
            }
        }
    }

    private void prepareUdpClient(Publisher<String> publisher, Supplier<SocketAddress> remoteAddress) {
        AtomicReference<ClientTransport> udpClientReference = new AtomicReference<ClientTransport>();
        ClientTransport udpClient = ((UdpClient)UdpClient.create().remoteAddress(remoteAddress)).handle((in, out) -> out.sendString(publisher).neverComplete().retryWhen(Retry.indefinitely().filter(throwable -> throwable instanceof PortUnreachableException))).doOnDisconnected(connection -> {
            Boolean connectionDisposed = connection.channel().attr(CONNECTION_DISPOSED).getAndSet(Boolean.TRUE);
            if (connectionDisposed == null || !connectionDisposed.booleanValue()) {
                this.connectAndSubscribe((UdpClient)udpClientReference.get());
            }
        });
        udpClientReference.set(udpClient);
        this.connectAndSubscribe((UdpClient)udpClient);
    }

    private void prepareTcpClient(Publisher<String> publisher) {
        AtomicReference<ClientTransport> tcpClientReference = new AtomicReference<ClientTransport>();
        ClientTransport tcpClient = TcpClient.create().host(this.statsdConfig.host()).port(this.statsdConfig.port()).handle((in, out) -> out.sendString(publisher).neverComplete()).doOnDisconnected(connection -> {
            Boolean connectionDisposed = connection.channel().attr(CONNECTION_DISPOSED).getAndSet(Boolean.TRUE);
            if (connectionDisposed == null || !connectionDisposed.booleanValue()) {
                this.connectAndSubscribe((TcpClient)tcpClientReference.get());
            }
        });
        tcpClientReference.set(tcpClient);
        this.connectAndSubscribe((TcpClient)tcpClient);
    }

    private void connectAndSubscribe(TcpClient tcpClient) {
        this.retryReplaceClient(Mono.defer(() -> {
            if (this.started.get()) {
                return tcpClient.connect();
            }
            return Mono.empty();
        }));
    }

    private void connectAndSubscribe(UdpClient udpClient) {
        this.retryReplaceClient(Mono.defer(() -> {
            if (this.started.get()) {
                return udpClient.connect();
            }
            return Mono.empty();
        }));
    }

    private void retryReplaceClient(Mono<? extends Connection> connectMono) {
        connectMono.retryWhen(Retry.backoff(Long.MAX_VALUE, Duration.ofSeconds(1L)).maxBackoff(Duration.ofMinutes(1L))).subscribe(connection -> {
            this.statsdConnection.replace((Disposable)connection);
            this.startPolling();
        });
    }

    private void startPolling() {
        this.meterPoller.update(Flux.interval(this.statsdConfig.pollingFrequency()).doOnEach(n -> this.poll()).subscribe());
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            if (this.statsdConnection.get() != null) {
                ((Disposable)this.statsdConnection.get()).dispose();
            }
            if (this.meterPoller.get() != null) {
                ((Disposable)this.meterPoller.get()).dispose();
            }
        }
    }

    public void close() {
        this.poll();
        this.stop();
        super.close();
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        StatsdGauge<T> gauge = new StatsdGauge<T>(id, this.lineBuilder(id), this.sink, obj, valueFunction, this.statsdConfig.publishUnchangedMeters());
        this.pollableMeters.put(id, gauge);
        return gauge;
    }

    private StatsdLineBuilder lineBuilder(Meter.Id id) {
        return this.lineBuilder(id, null);
    }

    private StatsdLineBuilder lineBuilder(Meter.Id id, @Nullable DistributionStatisticConfig distributionStatisticConfig) {
        if (this.lineBuilderFunction == null) {
            this.lineBuilderFunction = (id2, dsc2) -> {
                switch (this.statsdConfig.flavor()) {
                    case DATADOG: {
                        return new DatadogStatsdLineBuilder((Meter.Id)id2, this.config(), (DistributionStatisticConfig)dsc2);
                    }
                    case TELEGRAF: {
                        return new TelegrafStatsdLineBuilder((Meter.Id)id2, this.config());
                    }
                    case SYSDIG: {
                        return new SysdigStatsdLineBuilder((Meter.Id)id2, this.config());
                    }
                }
                return new EtsyStatsdLineBuilder((Meter.Id)id2, this.config(), this.nameMapper);
            };
        }
        return this.lineBuilderFunction.apply(id, distributionStatisticConfig);
    }

    private DistributionStatisticConfig addInfBucket(DistributionStatisticConfig config) {
        double[] dArray;
        if (config.getServiceLevelObjectiveBoundaries() == null) {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = Double.POSITIVE_INFINITY;
        } else {
            dArray = DoubleStream.concat(Arrays.stream(config.getServiceLevelObjectiveBoundaries()), DoubleStream.of(Double.POSITIVE_INFINITY)).toArray();
        }
        double[] serviceLevelObjectives = dArray;
        return DistributionStatisticConfig.builder().serviceLevelObjectives(serviceLevelObjectives).build().merge(config);
    }

    protected Counter newCounter(Meter.Id id) {
        return new StatsdCounter(id, this.lineBuilder(id), this.sink);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        StatsdLongTaskTimer ltt = new StatsdLongTaskTimer(id, this.lineBuilder(id, distributionStatisticConfig), this.sink, this.clock, this.statsdConfig.publishUnchangedMeters(), distributionStatisticConfig, this.getBaseTimeUnit());
        HistogramGauges.registerWithCommonFormat((LongTaskTimer)ltt, (MeterRegistry)this);
        this.pollableMeters.put(id, ltt);
        return ltt;
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        if (distributionStatisticConfig.getServiceLevelObjectiveBoundaries() != null) {
            distributionStatisticConfig = this.addInfBucket(distributionStatisticConfig);
        }
        StatsdTimer timer = new StatsdTimer(id, this.lineBuilder(id, distributionStatisticConfig), this.sink, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.statsdConfig.step().toMillis());
        HistogramGauges.registerWithCommonFormat((Timer)timer, (MeterRegistry)this);
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        if (distributionStatisticConfig.getServiceLevelObjectiveBoundaries() != null) {
            distributionStatisticConfig = this.addInfBucket(distributionStatisticConfig);
        }
        StatsdDistributionSummary summary = new StatsdDistributionSummary(id, this.lineBuilder(id, distributionStatisticConfig), this.sink, this.clock, distributionStatisticConfig, scale);
        HistogramGauges.registerWithCommonFormat((DistributionSummary)summary, (MeterRegistry)this);
        return summary;
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        StatsdFunctionCounter<T> fc = new StatsdFunctionCounter<T>(id, obj, countFunction, this.lineBuilder(id), this.sink);
        this.pollableMeters.put(id, fc);
        return fc;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        StatsdFunctionTimer<T> ft = new StatsdFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit(), this.lineBuilder(id), this.sink);
        this.pollableMeters.put(id, ft);
        return ft;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            StatsdLineBuilder line = this.lineBuilder(id);
            Statistic stat = ms.getStatistic();
            switch (stat) {
                case COUNT: 
                case TOTAL: 
                case TOTAL_TIME: {
                    this.pollableMeters.put(id.withTag(stat), () -> this.sink.tryEmitNext(line.count((long)ms.getValue(), stat)));
                    break;
                }
                case VALUE: 
                case ACTIVE_TASKS: 
                case DURATION: 
                case UNKNOWN: {
                    this.pollableMeters.put(id.withTag(stat), () -> this.sink.tryEmitNext(line.gauge(ms.getValue(), stat)));
                }
            }
        });
        return new DefaultMeter(id, type, measurements);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.statsdConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    @Deprecated
    public int queueSize() {
        return -1;
    }

    @Deprecated
    public int queueCapacity() {
        return -1;
    }

    private static final class NoopManySink
    implements Sinks.Many<String> {
        private NoopManySink() {
        }

        @Override
        public Sinks.EmitResult tryEmitNext(String s) {
            return Sinks.EmitResult.OK;
        }

        @Override
        public Sinks.EmitResult tryEmitComplete() {
            return Sinks.EmitResult.OK;
        }

        @Override
        public Sinks.EmitResult tryEmitError(Throwable error) {
            return Sinks.EmitResult.OK;
        }

        @Override
        public void emitNext(String s, Sinks.EmitFailureHandler failureHandler) {
        }

        @Override
        public void emitComplete(Sinks.EmitFailureHandler failureHandler) {
        }

        @Override
        public void emitError(Throwable error, Sinks.EmitFailureHandler failureHandler) {
        }

        @Override
        public int currentSubscriberCount() {
            return 0;
        }

        @Override
        public Flux<String> asFlux() {
            return Flux.empty();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            return null;
        }
    }

    @Incubating(since="1.0.1")
    public static class Builder {
        private final StatsdConfig config;
        private Clock clock = Clock.SYSTEM;
        private NamingConvention namingConvention;
        private HierarchicalNameMapper nameMapper = HierarchicalNameMapper.DEFAULT;
        @Nullable
        private BiFunction<Meter.Id, DistributionStatisticConfig, StatsdLineBuilder> lineBuilderFunction = null;
        @Nullable
        private Consumer<String> lineSink;

        Builder(StatsdConfig config) {
            this.config = config;
            this.namingConvention = StatsdMeterRegistry.namingConventionFromFlavor(config.flavor());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder lineBuilder(BiFunction<Meter.Id, DistributionStatisticConfig, StatsdLineBuilder> lineBuilderFunction) {
            this.lineBuilderFunction = lineBuilderFunction;
            return this;
        }

        @Deprecated
        public Builder lineBuilder(Function<Meter.Id, StatsdLineBuilder> lineBuilderFunction) {
            this.lineBuilderFunction = (id, dsc) -> (StatsdLineBuilder)lineBuilderFunction.apply((Meter.Id)id);
            return this;
        }

        public Builder nameMapper(HierarchicalNameMapper nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public Builder lineSink(Consumer<String> lineSink) {
            this.lineSink = lineSink;
            return this;
        }

        public StatsdMeterRegistry build() {
            return new StatsdMeterRegistry(this.config, this.nameMapper, this.namingConvention, this.clock, this.lineBuilderFunction, this.lineSink);
        }
    }
}

