/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.shaded.reactor.core.publisher.Sinks;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;

public class StatsdFunctionCounter<T>
extends CumulativeFunctionCounter<T>
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Sinks.Many<String> sink;
    private final AtomicReference<Long> lastValue = new AtomicReference<Long>(0L);

    StatsdFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> f, StatsdLineBuilder lineBuilder, Sinks.Many<String> sink) {
        super(id, obj, f);
        this.lineBuilder = lineBuilder;
        this.sink = sink;
    }

    @Override
    public void poll() {
        this.lastValue.updateAndGet(prev -> {
            long count = (long)this.count();
            this.sink.tryEmitNext(this.lineBuilder.count(count - prev));
            return count;
        });
    }
}

