/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.AbstractChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.channel.ContextAwareChannelMetricsRecorder;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;

final class ContextAwareChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ContextAwareChannelMetricsRecorder recorder;

    ContextAwareChannelMetricsHandler(ContextAwareChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ContextAwareConnectMetricsHandler(this.recorder());
    }

    @Override
    public ContextAwareChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        Connection connection = Connection.from(ctx.channel());
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            this.recorder().incrementErrorsCount(ops.currentContext(), address);
        } else if (connection instanceof ConnectionObserver) {
            this.recorder().incrementErrorsCount(((ConnectionObserver)((Object)connection)).currentContext(), address);
        } else {
            super.recordException(ctx, address);
        }
    }

    @Override
    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
        if (ops != null) {
            this.recorder().recordDataReceived(ops.currentContext(), address, bytes);
        } else {
            super.recordRead(ctx, address, bytes);
        }
    }

    @Override
    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
        if (ops != null) {
            this.recorder().recordDataSent(ops.currentContext(), address, bytes);
        } else {
            super.recordWrite(ctx, address, bytes);
        }
    }

    static final class ContextAwareConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ContextAwareChannelMetricsRecorder recorder;

        ContextAwareConnectMetricsHandler(ContextAwareChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ctx.pipeline().remove(this);
                this.recordConnectTime(ctx, remoteAddress, connectTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR");
            }));
        }

        void recordConnectTime(ChannelHandlerContext ctx, SocketAddress address, long connectTimeStart, String status) {
            Connection connection = Connection.from(ctx.channel());
            if (connection instanceof ConnectionObserver) {
                this.recorder.recordConnectTime(((ConnectionObserver)((Object)connection)).currentContext(), address, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
            } else {
                this.recorder.recordConnectTime(address, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
            }
        }
    }
}

