/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.channel.AbstractChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;

public class ChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ChannelMetricsRecorder recorder;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder());
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder);
    }

    @Override
    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        protected final ChannelMetricsRecorder recorder;

        TlsMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            long tlsHandshakeTimeStart = System.nanoTime();
            ctx.pipeline().get(SslHandler.class).handshakeFuture().addListener(f -> {
                ctx.pipeline().remove(this);
                this.recordTlsHandshakeTime(ctx, tlsHandshakeTimeStart, f.isSuccess() ? "SUCCESS" : "ERROR");
            });
            ctx.fireChannelActive();
        }

        protected void recordTlsHandshakeTime(ChannelHandlerContext ctx, long tlsHandshakeTimeStart, String status) {
            this.recorder.recordTlsHandshakeTime(ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
        }
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ctx.pipeline().remove(this);
                this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
            }));
        }
    }
}

