/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientFinalizer;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.WebsocketClientOperations;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class WebsocketFinalizer
extends HttpClient
implements HttpClient.WebsocketSender {
    final TcpClient cachedConfiguration;

    WebsocketFinalizer(TcpClient parent) {
        this.cachedConfiguration = parent;
    }

    @Override
    public HttpClient.WebsocketSender uri(String uri) {
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.uri(b, uri)));
    }

    @Override
    public HttpClient.WebsocketSender uri(Mono<String> uri) {
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.deferredConf(b, conf -> uri.map(conf::uri))));
    }

    public WebsocketFinalizer send(Function<? super HttpClientRequest, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.body(b, (req, out) -> (Publisher)sender.apply((HttpClientRequest)req))));
    }

    @Override
    public Mono<WebsocketClientOperations> connect() {
        return this.cachedConfiguration.connect();
    }

    @Override
    public ByteBufFlux receive() {
        return HttpClientFinalizer.content(this.cachedConfiguration, HttpClientFinalizer.contentReceiver);
    }

    @Override
    public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(c -> Flux.from((Publisher)receiver.apply((WebsocketInbound)c, (WebsocketOutbound)c)));
    }
}

