/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class HttpClientDoOn
extends HttpClientOperator
implements ConnectionObserver,
Function<Bootstrap, Bootstrap> {
    final BiConsumer<? super HttpClientRequest, ? super Connection> onRequest;
    final BiConsumer<? super HttpClientRequest, ? super Connection> afterRequest;
    final BiConsumer<? super HttpClientResponse, ? super Connection> onResponse;
    final BiConsumer<? super HttpClientResponse, ? super Connection> afterResponse;

    HttpClientDoOn(HttpClient client, @Nullable BiConsumer<? super HttpClientRequest, ? super Connection> onRequest, @Nullable BiConsumer<? super HttpClientRequest, ? super Connection> afterRequest, @Nullable BiConsumer<? super HttpClientResponse, ? super Connection> onResponse, @Nullable BiConsumer<? super HttpClientResponse, ? super Connection> afterResponse) {
        super(client);
        this.onRequest = onRequest;
        this.afterRequest = afterRequest;
        this.onResponse = onResponse;
        this.afterResponse = afterResponse;
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(bootstrap);
        BootstrapHandlers.connectionObserver(bootstrap, observer.then(this));
        return bootstrap;
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (this.onRequest != null && newState == ConnectionObserver.State.CONFIGURED) {
            this.onRequest.accept(connection.as(HttpClientOperations.class), connection);
            return;
        }
        if (this.afterResponse != null) {
            if (newState == ConnectionObserver.State.RELEASED) {
                this.afterResponse.accept(connection.as(HttpClientOperations.class), connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING) {
                connection.onDispose(() -> this.afterResponse.accept(connection.as(HttpClientOperations.class), connection));
            }
            return;
        }
        if (this.afterRequest != null && newState == HttpClientOperations.REQUEST_SENT) {
            this.afterRequest.accept(connection.as(HttpClientOperations.class), connection);
            return;
        }
        if (this.onResponse != null && newState == HttpClientOperations.RESPONSE_RECEIVED) {
            this.onResponse.accept(connection.as(HttpClientOperations.class), connection);
        }
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }
}

