/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.GroupedFlux;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;

final class GroupedLift<K, I, O>
extends GroupedFlux<K, O>
implements Scannable {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;
    final GroupedFlux<K, I> source;

    GroupedLift(GroupedFlux<K, I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public K key() {
        return this.source.key();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply(this.source, actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        this.source.subscribe(input);
    }
}

