/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;

public class StatsdGauge<T>
extends AbstractMeter
implements Gauge,
StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> subscriber;
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;
    private final AtomicReference<Double> lastValue = new AtomicReference<Double>(Double.NaN);
    private final boolean alwaysPublish;
    private volatile boolean shutdown = false;

    StatsdGauge(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> subscriber, @Nullable T obj, ToDoubleFunction<T> value, boolean alwaysPublish) {
        super(id);
        this.lineBuilder = lineBuilder;
        this.subscriber = subscriber;
        this.ref = new WeakReference<T>(obj);
        this.value = value;
        this.alwaysPublish = alwaysPublish;
    }

    public double value() {
        Object obj = this.ref.get();
        return obj != null ? this.value.applyAsDouble(this.ref.get()) : Double.NaN;
    }

    @Override
    public void poll() {
        double val = this.value();
        if (!this.shutdown && Double.isFinite(val) && (this.alwaysPublish || this.lastValue.getAndSet(val) != val)) {
            this.subscriber.onNext(this.lineBuilder.gauge(val));
        }
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }

    void shutdown() {
        this.shutdown = true;
    }
}

