/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.util.context;

import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context0;
import io.micrometer.shaded.reactor.util.context.Context1;
import io.micrometer.shaded.reactor.util.context.Context2;
import io.micrometer.shaded.reactor.util.context.Context3;
import io.micrometer.shaded.reactor.util.context.Context4;
import io.micrometer.shaded.reactor.util.context.Context5;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;

public interface Context {
    public static Context empty() {
        return Context0.INSTANCE;
    }

    public static Context of(Object key, Object value) {
        return new Context1(key, value);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2) {
        return new Context2(key1, value1, key2, value2);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        return new Context3(key1, value1, key2, value2, key3, value3);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4) {
        return new Context4(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4, Object key5, Object value5) {
        return new Context5(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public <T> T get(Object var1);

    default public <T> T get(Class<T> key) {
        T v = this.get((Object)key);
        if (key.isInstance(v)) {
            return v;
        }
        throw new NoSuchElementException("Context does not contain a value of type " + key.getName());
    }

    @Nullable
    default public <T> T getOrDefault(Object key, @Nullable T defaultValue) {
        if (!this.hasKey(key)) {
            return defaultValue;
        }
        return this.get(key);
    }

    default public <T> Optional<T> getOrEmpty(Object key) {
        if (this.hasKey(key)) {
            return Optional.of(this.get(key));
        }
        return Optional.empty();
    }

    public boolean hasKey(Object var1);

    default public boolean isEmpty() {
        return this == Context0.INSTANCE || this instanceof Context0;
    }

    public Context put(Object var1, Object var2);

    public Context delete(Object var1);

    public Stream<Map.Entry<Object, Object>> stream();

    default public Context putAll(Context other) {
        if (other.isEmpty()) {
            return this;
        }
        return other.stream().reduce(this, (c, e) -> c.put(e.getKey(), e.getValue()), (c1, c2) -> {
            throw new UnsupportedOperationException("Context.putAll should not use a parallelized stream");
        });
    }
}

