/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.handler.ssl.JdkSslContext;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientOperator;
import java.util.Objects;

final class TcpClientRunOn
extends TcpClientOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpClientRunOn(TcpClient client, LoopResources loopResources, boolean preferNative) {
        super(client);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = this.source.configure();
        TcpClientRunOn.configure(b, this.preferNative, this.loopResources);
        return b;
    }

    static void configure(Bootstrap b, boolean preferNative, LoopResources resources) {
        SslProvider sslProvider = SslProvider.findSslSupport(b);
        boolean useNative = preferNative && (sslProvider == null || !(sslProvider.sslContext instanceof JdkSslContext));
        EventLoopGroup elg = resources.onClient(useNative);
        ((Bootstrap)b.group(elg)).channel(resources.onChannel(elg));
    }
}

