/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

final class HttpClientCookie
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Consumer<? super Cookie> cookie;
    final String name;
    final Cookie readyCookie;

    HttpClientCookie(HttpClient client, String name, Consumer<? super Cookie> cookie) {
        super(client);
        this.name = Objects.requireNonNull(name, "name");
        this.cookie = Objects.requireNonNull(cookie, "cookie");
        this.readyCookie = null;
    }

    HttpClientCookie(HttpClient client, Cookie cookie) {
        super(client);
        this.readyCookie = Objects.requireNonNull(cookie, "cookie");
        this.name = null;
        this.cookie = null;
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        Cookie c;
        HttpHeaders h = HttpClientConfiguration.headers(bootstrap);
        if (h == null) {
            h = new DefaultHttpHeaders();
        }
        if (this.readyCookie == null) {
            c = new DefaultCookie(this.name, "");
            this.cookie.accept(c);
        } else {
            c = this.readyCookie;
        }
        if (!c.value().isEmpty()) {
            h.add((CharSequence)HttpHeaderNames.COOKIE, (Object)HttpClientConfiguration.getOrCreate((Bootstrap)bootstrap).cookieEncoder.encode(c));
            HttpClientConfiguration.headers(bootstrap, h);
        }
        return bootstrap;
    }
}

