/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.ServerChannel;
import io.micrometer.shaded.io.netty.channel.kqueue.KQueue;
import io.micrometer.shaded.io.netty.channel.kqueue.KQueueDatagramChannel;
import io.micrometer.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.micrometer.shaded.io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.micrometer.shaded.io.netty.channel.kqueue.KQueueSocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import io.micrometer.shaded.reactor.netty.resources.ColocatedEventLoopGroup;
import io.micrometer.shaded.reactor.netty.resources.DefaultLoop;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.util.concurrent.ThreadFactory;

final class DefaultLoopKQueue
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopKQueue.class);
    private static final boolean kqueue;

    DefaultLoopKQueue() {
    }

    public static boolean hasKQueue() {
        return kqueue;
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new KQueueEventLoopGroup(threads, factory);
    }

    @Override
    public Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return this.useKQueue(group) ? KQueueServerSocketChannel.class : NioServerSocketChannel.class;
    }

    @Override
    public Class<? extends Channel> getChannel(EventLoopGroup group) {
        return this.useKQueue(group) ? KQueueSocketChannel.class : NioSocketChannel.class;
    }

    @Override
    public Class<? extends DatagramChannel> getDatagramChannel(EventLoopGroup group) {
        return this.useKQueue(group) ? KQueueDatagramChannel.class : NioDatagramChannel.class;
    }

    @Override
    public String getName() {
        return "kqueue";
    }

    private boolean useKQueue(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof KQueueEventLoopGroup;
    }

    static {
        boolean kqueueCheck = false;
        try {
            Class.forName("io.micrometer.shaded.io.netty.channel.kqueue.KQueue");
            kqueueCheck = KQueue.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        kqueue = kqueueCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default KQueue support : " + kqueue);
        }
    }
}

