/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import java.util.function.Function;

public class MemoizingFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> delegate;
    private volatile transient boolean initialized;
    private volatile transient T lastInput;
    private transient R value;

    public MemoizingFunction(Function<T, R> delegate) {
        this.delegate = delegate;
    }

    public static <U, V> MemoizingFunction<U, V> memoize(Function<U, V> delegate) {
        return new MemoizingFunction<U, V>(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T t) {
        if (!this.initialized || t != this.lastInput) {
            MemoizingFunction memoizingFunction = this;
            synchronized (memoizingFunction) {
                if (!this.initialized || t != this.lastInput) {
                    this.lastInput = t;
                    R r = this.delegate.apply(t);
                    this.value = r;
                    this.initialized = true;
                    return r;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Suppliers.memoize(" + this.delegate + ")";
    }
}

