/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;

public class StatsdFunctionCounter<T>
extends CumulativeFunctionCounter<T>
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> publisher;
    private final AtomicReference<Long> lastValue = new AtomicReference<Long>(0L);

    StatsdFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> f, StatsdLineBuilder lineBuilder, Subscriber<String> publisher) {
        super(id, obj, f);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    @Override
    public void poll() {
        this.lastValue.updateAndGet(prev -> {
            long count = (long)this.count();
            this.publisher.onNext(this.lineBuilder.count(count - prev));
            return count;
        });
    }
}

