/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.options;

import io.micrometer.shaded.io.netty.handler.proxy.HttpProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks4ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks5ProxyHandler;
import io.micrometer.shaded.reactor.ipc.netty.options.InetSocketAddressUtil;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class ClientProxyOptions {
    private final String username;
    private final Function<? super String, ? extends String> password;
    private final Supplier<? extends InetSocketAddress> address;
    private final Pattern nonProxyHosts;
    private final Proxy type;

    public static TypeSpec builder() {
        return new Build();
    }

    private ClientProxyOptions(Build builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.address = Objects.isNull(builder.address) ? () -> InetSocketAddressUtil.createResolved(builder.host, builder.port) : builder.address;
        this.nonProxyHosts = builder.nonProxyHosts != null ? Pattern.compile(builder.nonProxyHosts, 2) : null;
        this.type = builder.type;
    }

    public final Proxy getType() {
        return this.type;
    }

    public final Supplier<? extends InetSocketAddress> getAddress() {
        return this.address;
    }

    public final Pattern getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public final ProxyHandler newProxyHandler() {
        InetSocketAddress proxyAddr = this.address.get();
        String username = this.username;
        String password = Objects.nonNull(username) && Objects.nonNull(this.password) ? this.password.apply(username) : null;
        switch (this.type) {
            case HTTP: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new HttpProxyHandler(proxyAddr, username, password) : new HttpProxyHandler(proxyAddr);
            }
            case SOCKS4: {
                return Objects.nonNull(username) ? new Socks4ProxyHandler(proxyAddr, username) : new Socks4ProxyHandler(proxyAddr);
            }
            case SOCKS5: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new Socks5ProxyHandler(proxyAddr, username, password) : new Socks5ProxyHandler(proxyAddr);
            }
        }
        throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
    }

    public String asSimpleString() {
        return "proxy=" + (Object)((Object)this.type) + "(" + this.address.get() + ")";
    }

    public String asDetailedString() {
        return "address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHosts + ", type=" + (Object)((Object)this.type);
    }

    public String toString() {
        return "ClientProxyOptions{" + this.asDetailedString() + "}";
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public ClientProxyOptions build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        public Builder address(InetSocketAddress var1);

        public Builder address(Supplier<? extends InetSocketAddress> var1);
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    private static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        private String username;
        private Function<? super String, ? extends String> password;
        private String host;
        private int port;
        private Supplier<? extends InetSocketAddress> address;
        private String nonProxyHosts;
        private Proxy type;

        private Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder port(int port) {
            this.port = Objects.requireNonNull(Integer.valueOf(port), "port");
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> InetSocketAddressUtil.replaceWithResolved(address);
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            this.nonProxyHosts = nonProxyHostsPattern;
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public ClientProxyOptions build() {
            return new ClientProxyOptions(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

