/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketOutbound;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;

final class HttpServerWSOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound,
BiConsumer<Void, Throwable> {
    final WebSocketServerHandshaker handshaker;
    final ChannelPromise handshakerResult;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<HttpServerWSOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(HttpServerWSOperations.class, "closeSent");

    public HttpServerWSOperations(String wsUrl, String protocols, HttpServerOperations replaced) {
        super(replaced.channel(), replaced);
        Channel channel = replaced.channel();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, protocols, true);
        this.handshaker = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("io.micrometer.shaded.reactor.left.httpServerHandler");
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            this.handshaker.handshake(channel, (HttpRequest)request, replaced.nettyResponse.headers().remove(HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.markPersistent(false)));
        }
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug("CloseWebSocketFrame detected. Closing Websocket");
            }
            CloseWebSocketFrame close = (CloseWebSocketFrame)frame;
            this.sendClose(new CloseWebSocketFrame(true, close.rsv(), close.content()), f -> this.onHandlerTerminate());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        super.onInboundNext(ctx, frame);
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    public void accept(Void aVoid, Throwable throwable) {
        if (throwable == null) {
            if (this.channel().isActive()) {
                this.sendClose(null, f -> this.onHandlerTerminate());
            }
        } else {
            this.onOutboundError(throwable);
        }
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendClose(new CloseWebSocketFrame(1002, "Server internal error"), f -> this.onHandlerTerminate());
        }
    }

    void sendClose(CloseWebSocketFrame frame, ChannelFutureListener listener) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            ChannelFuture f = this.channel().writeAndFlush(frame == null ? new CloseWebSocketFrame() : frame);
            if (listener != null) {
                f.addListener(listener);
            }
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.selectedSubprotocol();
    }
}

