/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.reactor.ipc.netty.options.ServerOptions;

public final class HttpServerOptions
extends ServerOptions {
    private final int minCompressionResponseSize;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private final int initialBufferSize;
    private final boolean validateHeaders;

    public static Builder builder() {
        return new Builder();
    }

    private HttpServerOptions(Builder builder) {
        super(builder);
        this.minCompressionResponseSize = builder.minCompressionResponseSize;
        this.maxInitialLineLength = builder.maxInitialLineLength;
        this.maxHeaderSize = builder.maxHeaderSize;
        this.maxChunkSize = builder.maxChunkSize;
        this.validateHeaders = builder.validateHeaders;
        this.initialBufferSize = builder.initialBufferSize;
    }

    public int minCompressionResponseSize() {
        return this.minCompressionResponseSize;
    }

    public int httpCodecMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int httpCodecMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int httpCodecMaxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean httpCodecValidateHeaders() {
        return this.validateHeaders;
    }

    public int httpCodecInitialBufferSize() {
        return this.initialBufferSize;
    }

    @Override
    public HttpServerOptions duplicate() {
        return HttpServerOptions.builder().from(this).build();
    }

    @Override
    public String asSimpleString() {
        StringBuilder s = new StringBuilder(super.asSimpleString());
        if (this.minCompressionResponseSize >= 0) {
            s.append(", gzip");
            if (this.minCompressionResponseSize > 0) {
                s.append(" over ").append(this.minCompressionResponseSize).append(" bytes");
            }
        }
        return s.toString();
    }

    @Override
    public String asDetailedString() {
        return super.asDetailedString() + ", minCompressionResponseSize=" + this.minCompressionResponseSize + ", httpCodecSizes={initialLine=" + this.maxInitialLineLength + ",header=" + this.maxHeaderSize + ",chunk=" + this.maxChunkSize + "}";
    }

    @Override
    public String toString() {
        return "HttpServerOptions{" + this.asDetailedString() + "}";
    }

    public static final class Builder
    extends ServerOptions.Builder<Builder> {
        public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
        public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
        public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
        public static final boolean DEFAULT_VALIDATE_HEADERS = true;
        public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
        private int minCompressionResponseSize = -1;
        private int maxInitialLineLength = 4096;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;
        private boolean validateHeaders = true;
        private int initialBufferSize = 128;

        private Builder() {
            super(new ServerBootstrap());
        }

        public final Builder compression(boolean enabled) {
            this.minCompressionResponseSize = enabled ? 0 : -1;
            return (Builder)this.get();
        }

        public final Builder compression(int minResponseSize) {
            if (minResponseSize < 0) {
                throw new IllegalArgumentException("minResponseSize must be positive");
            }
            this.minCompressionResponseSize = minResponseSize;
            return (Builder)this.get();
        }

        public final Builder maxInitialLineLength(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("maxInitialLineLength must be strictly positive");
            }
            this.maxInitialLineLength = value;
            return (Builder)this.get();
        }

        public final Builder maxHeaderSize(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("maxHeaderSize must be strictly positive");
            }
            this.maxHeaderSize = value;
            return (Builder)this.get();
        }

        public final Builder maxChunkSize(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("maxChunkSize must be strictly positive");
            }
            this.maxChunkSize = value;
            return (Builder)this.get();
        }

        public final Builder validateHeaders(boolean validate) {
            this.validateHeaders = validate;
            return (Builder)this.get();
        }

        public final Builder initialBufferSize(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("initialBufferSize must be strictly positive");
            }
            this.initialBufferSize = value;
            return (Builder)this.get();
        }

        @Override
        public final Builder from(HttpServerOptions options) {
            super.from(options);
            this.minCompressionResponseSize = options.minCompressionResponseSize;
            this.maxInitialLineLength = options.maxInitialLineLength;
            this.maxHeaderSize = options.maxHeaderSize;
            this.maxChunkSize = options.maxChunkSize;
            this.validateHeaders = options.validateHeaders;
            this.initialBufferSize = options.initialBufferSize;
            return (Builder)this.get();
        }

        @Override
        public HttpServerOptions build() {
            super.build();
            return new HttpServerOptions(this);
        }
    }
}

