/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpContentCompressor;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;

final class FilteringHttpContentCompressor
extends HttpContentCompressor {
    FilteringHttpContentCompressor() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof FilterMessage) {
            FilterMessage filterMsg = (FilterMessage)msg;
            ctx.write(filterMsg.unwrap(), promise);
        } else if (msg instanceof LastHttpContent) {
            ctx.write(msg, promise);
        } else {
            if (msg instanceof ByteBuf) {
                msg = new DefaultHttpContent((ByteBuf)msg);
            }
            super.write(ctx, msg, promise);
        }
    }

    static final class FilterMessage {
        private final Object message;

        static FilterMessage wrap(Object msg) {
            return new FilterMessage(msg);
        }

        FilterMessage(Object message) {
            this.message = message;
        }

        Object unwrap() {
            return this.message;
        }
    }
}

