/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.client;

import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import io.micrometer.shaded.reactor.ipc.netty.NettyPipeline;
import io.micrometer.shaded.reactor.ipc.netty.http.HttpInfos;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketOutbound;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public interface HttpClientRequest
extends NettyOutbound,
HttpInfos {
    public HttpClientRequest addCookie(Cookie var1);

    public HttpClientRequest addHeader(CharSequence var1, CharSequence var2);

    @Override
    default public HttpClientRequest context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    public HttpClientRequest chunkedTransfer(boolean var1);

    @Override
    default public HttpClientRequest options(Consumer<? super NettyPipeline.SendOptions> configurator) {
        NettyOutbound.super.options(configurator);
        return this;
    }

    public HttpClientRequest followRedirect();

    public HttpClientRequest failOnClientError(boolean var1);

    public HttpClientRequest failOnServerError(boolean var1);

    public boolean hasSentHeaders();

    public HttpClientRequest header(CharSequence var1, CharSequence var2);

    public HttpClientRequest headers(HttpHeaders var1);

    public boolean isFollowRedirect();

    public HttpClientRequest keepAlive(boolean var1);

    @Override
    default public HttpClientRequest onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        NettyOutbound.super.onWriteIdle(idleTimeout, onWriteIdle);
        return this;
    }

    public String[] redirectedFrom();

    public HttpHeaders requestHeaders();

    default public Mono<Void> send() {
        return this.sendObject(Unpooled.EMPTY_BUFFER).then();
    }

    public Flux<Long> sendForm(Consumer<Form> var1);

    public NettyOutbound sendHeaders();

    public WebsocketOutbound sendWebsocket();

    public WebsocketOutbound sendWebsocket(String var1);

    public static interface Form {
        public Form attr(String var1, String var2);

        public Form charset(Charset var1);

        public Form cleanOnTerminate(boolean var1);

        public Form encoding(HttpPostRequestEncoder.EncoderMode var1);

        public Form factory(HttpDataFactory var1);

        public Form file(String var1, File var2);

        public Form file(String var1, InputStream var2);

        default public Form file(String name, File file, String contentType) {
            return this.file(name, file.getName(), file, contentType);
        }

        public Form file(String var1, String var2, File var3, String var4);

        default public Form file(String name, InputStream stream, String contentType) {
            return this.file(name, "", stream, contentType);
        }

        public Form file(String var1, String var2, InputStream var3, String var4);

        public Form files(String var1, File[] var2, String[] var3);

        public Form files(String var1, File[] var2, String[] var3, boolean[] var4);

        public Form multipart(boolean var1);

        public Form textFile(String var1, File var2);

        public Form textFile(String var1, InputStream var2);

        public Form textFile(String var1, File var2, String var3);

        public Form textFile(String var1, InputStream var2, String var3);
    }
}

