/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.io.netty.util.Attribute;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.ipc.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.ReactorNetty;
import java.net.InetSocketAddress;
import java.util.function.Consumer;

public interface NettyInbound {
    default public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.context().channel().attr(key);
    }

    public NettyContext context();

    default public NettyInbound context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    default public NettyInbound onReadIdle(long idleTimeout, Runnable onReadIdle) {
        this.context().removeHandler("io.micrometer.shaded.reactor.left.onChannelReadIdle");
        this.context().addHandlerFirst("io.micrometer.shaded.reactor.left.onChannelReadIdle", new ReactorNetty.InboundIdleStateHandler(idleTimeout, onReadIdle));
        return this;
    }

    default public ByteBufFlux receive() {
        return ByteBufFlux.fromInbound(this.receiveObject(), this.context().channel().alloc());
    }

    public Flux<?> receiveObject();

    default public InetSocketAddress remoteAddress() {
        return this.context().address();
    }
}

