/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Processor;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.FluxProcessor;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.ReplayProcessor;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.concurrent.WaitStrategy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongSupplier;

public final class MonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
CoreSubscriber<O>,
Disposable,
Subscription,
Scannable,
LongSupplier {
    final WaitStrategy waitStrategy;
    Publisher<? extends O> source;
    Subscription subscription;
    volatile FluxProcessor<O, O> processor;
    volatile O value;
    volatile Throwable error;
    volatile int state;
    volatile int wip;
    volatile int connected;
    static final NoopProcessor NOOP_PROCESSOR = new NoopProcessor();
    static final AtomicIntegerFieldUpdater<MonoProcessor> STATE = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "state");
    static final AtomicIntegerFieldUpdater<MonoProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "wip");
    static final AtomicIntegerFieldUpdater<MonoProcessor> CONNECTED = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "connected");
    static final AtomicReferenceFieldUpdater<MonoProcessor, FluxProcessor> PROCESSOR = AtomicReferenceFieldUpdater.newUpdater(MonoProcessor.class, FluxProcessor.class, "processor");
    static final int STATE_CANCELLED = -1;
    static final int STATE_READY = 0;
    static final int STATE_SUBSCRIBED = 1;
    static final int STATE_POST_SUBSCRIBED = 2;
    static final int STATE_SUCCESS_VALUE = 3;
    static final int STATE_COMPLETE_NO_VALUE = 4;
    static final int STATE_ERROR = 5;

    public static <T> MonoProcessor<T> create() {
        return new MonoProcessor(null);
    }

    public static <T> MonoProcessor<T> create(WaitStrategy waitStrategy) {
        return new MonoProcessor(null, waitStrategy);
    }

    MonoProcessor(@Nullable Publisher<? extends O> source) {
        this(source, WaitStrategy.sleeping());
    }

    MonoProcessor(@Nullable Publisher<? extends O> source, WaitStrategy waitStrategy) {
        this.source = source;
        this.waitStrategy = Objects.requireNonNull(waitStrategy, "waitStrategy");
    }

    @Override
    public final void cancel() {
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                return;
            }
            if (STATE.compareAndSet(this, state, -1)) break;
            state = this.state;
        }
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    @Nullable
    public O block() {
        return this.block(WaitStrategy.NOOP_SPIN_OBSERVER);
    }

    @Override
    @Nullable
    public O block(Duration timeout) {
        long delay = System.nanoTime() + timeout.toNanos();
        Runnable spinObserver = () -> {
            if (delay < System.nanoTime()) {
                WaitStrategy.alert();
            }
        };
        return this.block(spinObserver);
    }

    @Nullable
    O block(Runnable spinObserver) {
        try {
            if (!this.isPending()) {
                return this.peek();
            }
            if (this.subscription == null) {
                this.getOrStart();
            }
            try {
                long endState = this.waitStrategy.waitFor(3L, this, spinObserver);
                switch ((int)endState) {
                    case 3: {
                        return this.value;
                    }
                    case 5: {
                        RuntimeException re = Exceptions.propagate(this.error);
                        re = Exceptions.addSuppressed(re, (Throwable)new Exception("Mono#block terminated with an error"));
                        throw re;
                    }
                    case 4: {
                        return null;
                    }
                }
                throw new IllegalStateException("Mono has been cancelled");
            }
            catch (RuntimeException ce) {
                if (WaitStrategy.isAlert(ce)) {
                    this.cancel();
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                throw ce;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    public boolean isCancelled() {
        return this.state == -1;
    }

    public final boolean isError() {
        return this.state == 5;
    }

    public final boolean isSuccess() {
        return this.state == 4 || this.state == 3;
    }

    public final boolean isTerminated() {
        return this.state > 2;
    }

    @Override
    public boolean isDisposed() {
        return this.isTerminated() || this.isCancelled();
    }

    @Override
    public final void onComplete() {
        Subscription s = this.subscription;
        int state = this.state;
        if (this.source != null && s == null || state >= 3) {
            return;
        }
        this.subscription = null;
        this.source = null;
        int finalState = 4;
        while (true) {
            if (STATE.compareAndSet(this, state, 4)) break;
            state = this.state;
        }
        this.waitStrategy.signalAllWhenBlocking();
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public final void onError(Throwable cause) {
        Subscription s = this.subscription;
        if (this.source != null && s == null || this.error != null) {
            Operators.onErrorDroppedMulticast(cause);
            return;
        }
        this.error = cause;
        this.subscription = null;
        this.source = null;
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                Operators.onErrorDroppedMulticast(cause);
                return;
            }
            if (STATE.compareAndSet(this, state, 5)) break;
            state = this.state;
        }
        this.waitStrategy.signalAllWhenBlocking();
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public final void onNext(O value) {
        int finalState;
        Subscription s = this.subscription;
        if (value != null && (this.source != null && s == null || this.value != null)) {
            Operators.onNextDroppedMulticast(value);
            return;
        }
        this.subscription = null;
        if (value != null) {
            finalState = 3;
            this.value = value;
            if (s != null && !(this.source instanceof Mono)) {
                s.cancel();
            }
        } else {
            finalState = 4;
        }
        this.source = null;
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                if (value != null) {
                    Operators.onNextDroppedMulticast(value);
                }
                return;
            }
            if (STATE.compareAndSet(this, state, finalState)) break;
            state = this.state;
        }
        this.waitStrategy.signalAllWhenBlocking();
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public final void onSubscribe(Subscription subscription) {
        if (Operators.validate(this.subscription, subscription)) {
            this.subscription = subscription;
            if (STATE.compareAndSet(this, 0, 1)) {
                subscription.request(Long.MAX_VALUE);
            }
            if (WIP.getAndIncrement(this) == 0) {
                this.drainLoop();
            }
        }
    }

    @Override
    public long getAsLong() {
        return this.state;
    }

    @Nullable
    public O peek() {
        int endState = this.state;
        if (endState == 3) {
            return this.value;
        }
        if (endState == 5) {
            RuntimeException re = Exceptions.propagate(this.error);
            re = Exceptions.addSuppressed(re, (Throwable)new Exception("Mono#peek terminated with an error"));
            throw re;
        }
        return null;
    }

    @Override
    public final void request(long n) {
        if (Operators.validate(n) && WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        FluxProcessor<O, O> out;
        do {
            int endState;
            if ((endState = this.state) == 4) {
                Operators.complete(actual);
                return;
            }
            if (endState == 3) {
                actual.onSubscribe(Operators.scalarSubscription(actual, this.value));
                return;
            }
            if (endState == 5) {
                Operators.error(actual, this.error);
                return;
            }
            if (endState != -1) continue;
            Operators.error(actual, new CancellationException("Mono has previously been cancelled"));
            return;
        } while ((out = this.getOrStart()) == NOOP_PROCESSOR);
        out.subscribe(actual);
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL) {
            return this.processor;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.error;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return this.isCancelled();
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.isTerminated();
        }
        return null;
    }

    final boolean isPending() {
        return !this.isTerminated() && !this.isCancelled();
    }

    final void connect() {
        if (CONNECTED.compareAndSet(this, 0, 1)) {
            if (this.source == null) {
                this.onSubscribe(Operators.emptySubscription());
            } else {
                this.source.subscribe(this);
            }
        }
    }

    public final long downstreamCount() {
        return Scannable.from(this.processor).inners().count();
    }

    public final boolean hasDownstreams() {
        return this.downstreamCount() != 0L;
    }

    final void drainLoop() {
        int missed = 1;
        do {
            Processor p;
            Processor p2;
            int state;
            if ((state = this.state) > 2 && (p2 = (Processor)PROCESSOR.getAndSet(this, NOOP_PROCESSOR)) != NOOP_PROCESSOR && p2 != null) {
                switch (state) {
                    case 4: {
                        p2.onComplete();
                        break;
                    }
                    case 3: {
                        p2.onNext(this.value);
                        p2.onComplete();
                        break;
                    }
                    case 5: {
                        p2.onError(this.error);
                    }
                }
                return;
            }
            Subscription subscription = this.subscription;
            if (subscription != null && state == -1 && (p = PROCESSOR.getAndSet(this, NOOP_PROCESSOR)) != NOOP_PROCESSOR) {
                this.subscription = null;
                this.source = null;
                subscription.cancel();
                if (p != null) {
                    ((FluxProcessor)p).dispose();
                }
                return;
            }
            if (state != 1 || !STATE.compareAndSet(this, 1, 2) || (p = (Processor)PROCESSOR.get(this)) == null || p == NOOP_PROCESSOR) continue;
            p.onSubscribe(this);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    FluxProcessor<O, O> getOrStart() {
        ReplayProcessor<O> out = this.processor;
        if (out == null) {
            out = ReplayProcessor.cacheLastOrDefault(this.value);
            if (PROCESSOR.compareAndSet(this, null, out)) {
                this.connect();
            } else {
                out = PROCESSOR.get(this);
            }
        }
        return out;
    }

    static final class NoopProcessor
    extends FluxProcessor {
        NoopProcessor() {
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onNext(Object o) {
        }

        @Override
        public void onSubscribe(Subscription s) {
        }

        @Override
        public void subscribe(CoreSubscriber actual) {
        }
    }
}

