/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Disposables;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.InnerProducer;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.OperatorDisposables;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class MonoDelay
extends Mono<Long>
implements Scannable {
    final Scheduler timedScheduler;
    final long delay;
    final TimeUnit unit;

    MonoDelay(long delay, TimeUnit unit, Scheduler timedScheduler) {
        this.delay = delay;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    @Override
    public void subscribe(CoreSubscriber<? super Long> actual) {
        block2: {
            MonoDelayRunnable r = new MonoDelayRunnable(actual);
            actual.onSubscribe(r);
            try {
                r.setCancel(this.timedScheduler.schedule(r, this.delay, this.unit));
            }
            catch (RejectedExecutionException ree) {
                if (r.cancel == OperatorDisposables.DISPOSED) break block2;
                actual.onError(Operators.onRejectedExecution(ree, r, null, null, actual.currentContext()));
            }
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.timedScheduler;
        }
        return null;
    }

    static final class MonoDelayRunnable
    implements Runnable,
    InnerProducer<Long> {
        final CoreSubscriber<? super Long> actual;
        volatile Disposable cancel;
        static final AtomicReferenceFieldUpdater<MonoDelayRunnable, Disposable> CANCEL = AtomicReferenceFieldUpdater.newUpdater(MonoDelayRunnable.class, Disposable.class, "cancel");
        volatile boolean requested;
        static final Disposable FINISHED = Disposables.disposed();

        MonoDelayRunnable(CoreSubscriber<? super Long> actual) {
            this.actual = actual;
        }

        public void setCancel(Disposable cancel) {
            if (!CANCEL.compareAndSet(this, null, cancel)) {
                cancel.dispose();
            }
        }

        @Override
        public CoreSubscriber<? super Long> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.cancel == FINISHED;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancel == OperatorDisposables.DISPOSED;
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        public void run() {
            if (this.requested) {
                try {
                    if (CANCEL.getAndSet(this, FINISHED) != OperatorDisposables.DISPOSED) {
                        this.actual.onNext((Long)0L);
                        this.actual.onComplete();
                    }
                }
                catch (Throwable t) {
                    this.actual.onError(Operators.onOperatorError(t, this.actual.currentContext()));
                }
            } else {
                this.actual.onError(Exceptions.failWithOverflow("Could not emit value due to lack of requests"));
            }
        }

        @Override
        public void cancel() {
            Disposable c = this.cancel;
            if (c != OperatorDisposables.DISPOSED && c != FINISHED && (c = CANCEL.getAndSet(this, OperatorDisposables.DISPOSED)) != null && c != OperatorDisposables.DISPOSED && c != FINISHED) {
                c.dispose();
            }
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                this.requested = true;
            }
        }
    }
}

