/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

final class MonoCompletionStage<T>
extends Mono<T>
implements Fuseable {
    final CompletionStage<? extends T> future;

    MonoCompletionStage(CompletionStage<? extends T> future) {
        this.future = Objects.requireNonNull(future, "future");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(actual);
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        this.future.whenComplete((v, e) -> {
            if (e != null) {
                actual.onError((Throwable)e);
            } else if (v != null) {
                sds.complete(v);
            } else {
                actual.onComplete();
            }
        });
    }
}

