/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class StackdriverNamingConvention
implements NamingConvention {
    private static final int MAX_NAME_LENGTH = 200;
    private static final int MAX_TAG_KEY_LENGTH = 100;
    private static final Pattern NAME_WHITELIST = Pattern.compile("[^\\w./]");
    private static final Pattern TAG_KEY_WHITELIST = Pattern.compile("[^\\w]");
    private final NamingConvention nameDelegate;
    private final NamingConvention tagKeyDelegate;

    public StackdriverNamingConvention() {
        this(NamingConvention.slashes, NamingConvention.snakeCase);
    }

    public StackdriverNamingConvention(NamingConvention nameDelegate, NamingConvention tagKeyDelegate) {
        this.nameDelegate = nameDelegate;
        this.tagKeyDelegate = tagKeyDelegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return StringUtils.truncate((String)NAME_WHITELIST.matcher(this.nameDelegate.name(name, type, baseUnit)).replaceAll("_"), (int)200);
    }

    public String tagKey(String key) {
        return StringUtils.truncate((String)TAG_KEY_WHITELIST.matcher(this.tagKeyDelegate.tagKey(key)).replaceAll("_"), (int)100);
    }
}

