/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.step.StepTuple2;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

final class SignalfxDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final StepTuple2<Long, Double> countTotal;
    private final TimeWindowMax max;

    SignalfxDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, long stepMillis) {
        super(id, clock, CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig), scale, false);
        this.countTotal = new StepTuple2(clock, stepMillis, (Object)0L, (Object)0.0, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.total.add(amount);
        this.max.record(amount);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalAmount() {
        return (Double)this.countTotal.poll2();
    }

    public double max() {
        return this.max.poll();
    }
}

