/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.prometheus.PrometheusConfig;
import io.prometheus.client.Collector;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MicrometerCollector
extends Collector {
    private final Meter.Id id;
    private final List<Child> children = new CopyOnWriteArrayList<Child>();
    private final String conventionName;
    private final List<String> tagKeys;
    private final PrometheusConfig config;

    public MicrometerCollector(Meter.Id id, NamingConvention convention, PrometheusConfig config) {
        this.id = id;
        this.conventionName = id.getConventionName(convention);
        this.tagKeys = id.getConventionTags(convention).stream().map(Tag::getKey).collect(Collectors.toList());
        this.config = config;
    }

    public void add(Child child) {
        this.children.add(child);
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public List<Collector.MetricFamilySamples> collect() {
        String help = this.config.descriptions() ? Optional.ofNullable(this.id.getDescription()).orElse(" ") : " ";
        return this.children.stream().flatMap(child -> child.samples(this.conventionName, this.tagKeys)).collect(Collectors.groupingBy(Family::getConventionName, Collectors.reducing((a, b) -> new Family(a.type, a.conventionName, Stream.concat(a.samples, b.samples))))).values().stream().map(Optional::get).map(family -> new Collector.MetricFamilySamples(family.conventionName, family.type, help, family.samples.collect(Collectors.toList()))).collect(Collectors.toList());
    }

    static class Family {
        final Collector.Type type;
        final String conventionName;
        final Stream<Collector.MetricFamilySamples.Sample> samples;

        Family(Collector.Type type, String conventionName, Stream<Collector.MetricFamilySamples.Sample> samples) {
            this.type = type;
            this.conventionName = conventionName;
            this.samples = samples;
        }

        String getConventionName() {
            return this.conventionName;
        }
    }

    static interface Child {
        public Stream<Family> samples(String var1, List<String> var2);
    }
}

