/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpHistogramSupport;
import io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import io.micrometer.registry.otlp.OtlpStepTuple2;
import io.micrometer.registry.otlp.StepMax;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.jspecify.annotations.Nullable;

class OtlpStepDistributionSummary
extends AbstractDistributionSummary
implements OtlpHistogramSupport {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final OtlpStepTuple2<Long, Double> countTotal;
    private final StepMax max;

    OtlpStepDistributionSummary(Meter.Id id, Clock clock, double scale, Histogram histogram, OtlpConfig otlpConfig) {
        super(id, scale, histogram);
        this.countTotal = new OtlpStepTuple2<Long, Double>(clock, otlpConfig.step().toMillis(), 0L, 0.0, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new StepMax(clock, otlpConfig.step().toMillis());
    }

    protected void recordNonNegative(double amount) {
        this.count.add(1L);
        this.total.add(amount);
        this.max.record(amount);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalAmount() {
        return (Double)this.countTotal.poll2();
    }

    public double max() {
        return (Double)this.max.poll();
    }

    @Override
    public @Nullable ExponentialHistogramSnapShot getExponentialHistogramSnapShot() {
        if (this.histogram instanceof Base2ExponentialHistogram) {
            return ((Base2ExponentialHistogram)this.histogram).getLatestExponentialHistogramSnapshot();
        }
        return null;
    }

    void _closingRollover() {
        this.countTotal._closingRollover();
        this.max._closingRollover();
        if (this.histogram instanceof OtlpStepBucketHistogram) {
            ((OtlpStepBucketHistogram)this.histogram)._closingRollover();
        } else if (this.histogram instanceof Base2ExponentialHistogram) {
            this.histogram.close();
        }
    }
}

