/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.NoopHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepFunctionCounter;
import io.micrometer.core.instrument.step.StepFunctionTimer;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpCumulativeCounter;
import io.micrometer.registry.otlp.OtlpCumulativeDistributionSummary;
import io.micrometer.registry.otlp.OtlpCumulativeFunctionCounter;
import io.micrometer.registry.otlp.OtlpCumulativeFunctionTimer;
import io.micrometer.registry.otlp.OtlpCumulativeLongTaskTimer;
import io.micrometer.registry.otlp.OtlpCumulativeTimer;
import io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import io.micrometer.registry.otlp.OtlpStepDistributionSummary;
import io.micrometer.registry.otlp.OtlpStepTimer;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class OtlpMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("otlp-metrics-publisher");
    private final InternalLogger logger = InternalLoggerFactory.getInstance(OtlpMeterRegistry.class);
    private final OtlpConfig config;
    private final HttpSender httpSender;
    private final Resource resource;
    private final io.opentelemetry.proto.metrics.v1.AggregationTemporality otlpAggregationTemporality;
    private long deltaAggregationTimeUnixNano = 0L;
    @Nullable
    private ScheduledExecutorService meterPollingService;

    public OtlpMeterRegistry() {
        this(OtlpConfig.DEFAULT, Clock.SYSTEM);
    }

    public OtlpMeterRegistry(OtlpConfig config, Clock clock) {
        this(config, clock, (HttpSender)new HttpUrlConnectionSender());
    }

    private OtlpMeterRegistry(OtlpConfig config, Clock clock, HttpSender httpSender) {
        super((PushRegistryConfig)config, clock);
        this.config = config;
        this.httpSender = httpSender;
        this.resource = Resource.newBuilder().addAllAttributes(this.getResourceAttributes()).build();
        this.otlpAggregationTemporality = AggregationTemporality.toOtlpAggregationTemporality(config.aggregationTemporality());
        this.setDeltaAggregationTimeUnixNano();
        this.config().namingConvention(NamingConvention.dot);
        this.start(DEFAULT_THREAD_FACTORY);
    }

    public void start(ThreadFactory threadFactory) {
        super.start(threadFactory);
        if (this.config.enabled() && this.isDelta()) {
            this.meterPollingService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.meterPollingService.scheduleAtFixedRate(this::pollMetersToRollover, this.getInitialDelay(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        super.stop();
        if (this.meterPollingService != null) {
            this.meterPollingService.shutdown();
        }
    }

    protected void publish() {
        if (this.isDelta()) {
            this.setDeltaAggregationTimeUnixNano();
        }
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            List metrics = batch.stream().map(meter -> (Metric)meter.match(this::writeGauge, this::writeCounter, this::writeHistogramSupport, this::writeHistogramSupport, this::writeHistogramSupport, this::writeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).collect(Collectors.toList());
            try {
                ExportMetricsServiceRequest request = ExportMetricsServiceRequest.newBuilder().addResourceMetrics(ResourceMetrics.newBuilder().setResource(this.resource).addScopeMetrics(ScopeMetrics.newBuilder().addAllMetrics(metrics).build()).build()).build();
                HttpSender.Request.Builder httpRequest = this.httpSender.post(this.config.url()).withContent("application/x-protobuf", request.toByteArray());
                this.config.headers().forEach((arg_0, arg_1) -> ((HttpSender.Request.Builder)httpRequest).withHeader(arg_0, arg_1));
                httpRequest.send();
            }
            catch (Throwable e) {
                this.logger.warn("Failed to publish metrics to OTLP receiver", e);
            }
        }
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return this.isCumulative() ? new OtlpCumulativeCounter(id, this.clock) : new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return this.isCumulative() ? new OtlpCumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit()) : new OtlpStepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis());
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return this.isCumulative() ? new OtlpCumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale, true) : new OtlpStepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis());
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return this.isCumulative() ? new OtlpCumulativeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit(), this.clock) : new StepFunctionTimer(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return this.isCumulative() ? new OtlpCumulativeFunctionCounter<T>(id, obj, countFunction, this.clock) : new StepFunctionCounter(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return this.isCumulative() ? new OtlpCumulativeLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig) : new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public void close() {
        this.stop();
        if (!this.isPublishing() && this.isDelta()) {
            if (!this.isDataPublishedForCurrentStep()) {
                try {
                    this.publish();
                }
                catch (Throwable e) {
                    this.logger.warn("Unexpected exception thrown while publishing metrics for " + ((Object)((Object)this)).getClass().getSimpleName(), e);
                }
            }
            this.getMeters().forEach(this::closingRollover);
        }
        super.close();
    }

    private boolean isDataPublishedForCurrentStep() {
        long currentTimeInMillis = this.clock.wallTime();
        return this.getLastScheduledPublishStartTime() / this.config.step().toMillis() >= currentTimeInMillis / this.config.step().toMillis();
    }

    private void closingRollover(Meter meter) {
        if (meter instanceof StepCounter) {
            ((StepCounter)meter)._closingRollover();
        }
        if (meter instanceof StepFunctionCounter) {
            ((StepFunctionCounter)meter)._closingRollover();
        }
        if (meter instanceof StepFunctionTimer) {
            ((StepFunctionTimer)meter)._closingRollover();
        }
        if (meter instanceof OtlpStepTimer) {
            ((OtlpStepTimer)meter)._closingRollover();
        }
        if (meter instanceof OtlpStepDistributionSummary) {
            ((OtlpStepDistributionSummary)meter)._closingRollover();
        }
    }

    Metric writeMeter(Meter meter) {
        return this.getMetricBuilder(meter.getId()).build();
    }

    Metric writeGauge(Gauge gauge) {
        return this.getMetricBuilder(gauge.getId()).setGauge(io.opentelemetry.proto.metrics.v1.Gauge.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setTimeUnixNano(this.getTimeUnixNano()).setAsDouble(gauge.value()).addAllAttributes(this.getTagsForId(gauge.getId())).build())).build();
    }

    Metric writeCounter(Counter counter) {
        return this.writeSum((Meter)counter, () -> ((Counter)counter).count());
    }

    Metric writeFunctionCounter(FunctionCounter functionCounter) {
        return this.writeSum((Meter)functionCounter, () -> ((FunctionCounter)functionCounter).count());
    }

    private Metric writeSum(Meter meter, DoubleSupplier count) {
        return this.getMetricBuilder(meter.getId()).setSum(Sum.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setStartTimeUnixNano(this.getStartTimeNanos(meter)).setTimeUnixNano(this.getTimeUnixNano()).setAsDouble(count.getAsDouble()).addAllAttributes(this.getTagsForId(meter.getId())).build()).setIsMonotonic(true).setAggregationTemporality(this.otlpAggregationTemporality).build()).build();
    }

    void pollMetersToRollover() {
        this.getMeters().forEach(m -> m.match(gauge -> null, Counter::count, HistogramSupport::takeSnapshot, HistogramSupport::takeSnapshot, meter -> null, meter -> null, FunctionCounter::count, FunctionTimer::count, meter -> null));
    }

    private long getInitialDelay() {
        long stepMillis = this.config.step().toMillis();
        return stepMillis - this.clock.wallTime() % stepMillis + 1L;
    }

    Metric writeHistogramSupport(HistogramSupport histogramSupport) {
        Metric.Builder metricBuilder = this.getMetricBuilder(histogramSupport.getId());
        boolean isTimeBased = histogramSupport instanceof Timer || histogramSupport instanceof LongTaskTimer;
        HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
        Iterable<? extends KeyValue> tags = this.getTagsForId(histogramSupport.getId());
        long startTimeNanos = this.getStartTimeNanos((Meter)histogramSupport);
        double total = isTimeBased ? histogramSnapshot.total(this.getBaseTimeUnit()) : histogramSnapshot.total();
        long count = histogramSnapshot.count();
        if (histogramSnapshot.percentileValues().length != 0) {
            SummaryDataPoint.Builder summaryData = SummaryDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(this.getTimeUnixNano()).setSum(total).setCount(count);
            for (ValueAtPercentile percentile : histogramSnapshot.percentileValues()) {
                summaryData.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(percentile.percentile()).setValue(TimeUtils.convert((double)percentile.value(), (TimeUnit)TimeUnit.NANOSECONDS, (TimeUnit)this.getBaseTimeUnit())));
            }
            metricBuilder.setSummary(Summary.newBuilder().addDataPoints(summaryData));
            return metricBuilder.build();
        }
        HistogramDataPoint.Builder histogramDataPoint = HistogramDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(this.getTimeUnixNano()).setSum(total).setCount(count);
        if (this.isDelta()) {
            histogramDataPoint.setMax(isTimeBased ? histogramSnapshot.max(this.getBaseTimeUnit()) : histogramSnapshot.max());
        }
        if (histogramSnapshot.histogramCounts().length != 0) {
            for (CountAtBucket countAtBucket : histogramSnapshot.histogramCounts()) {
                histogramDataPoint.addExplicitBounds(isTimeBased ? countAtBucket.bucket(this.getBaseTimeUnit()) : countAtBucket.bucket());
                histogramDataPoint.addBucketCounts((long)countAtBucket.count());
            }
            metricBuilder.setHistogram(Histogram.newBuilder().setAggregationTemporality(this.otlpAggregationTemporality).addDataPoints(histogramDataPoint));
            return metricBuilder.build();
        }
        return metricBuilder.setHistogram(Histogram.newBuilder().setAggregationTemporality(this.otlpAggregationTemporality).addDataPoints(histogramDataPoint)).build();
    }

    Metric writeFunctionTimer(FunctionTimer functionTimer) {
        return this.getMetricBuilder(functionTimer.getId()).setHistogram(Histogram.newBuilder().addDataPoints(HistogramDataPoint.newBuilder().addAllAttributes(this.getTagsForId(functionTimer.getId())).setStartTimeUnixNano(this.getStartTimeNanos((Meter)functionTimer)).setTimeUnixNano(this.getTimeUnixNano()).setSum(functionTimer.totalTime(this.getBaseTimeUnit())).setCount((long)functionTimer.count())).setAggregationTemporality(this.otlpAggregationTemporality)).build();
    }

    private boolean isCumulative() {
        return this.otlpAggregationTemporality == io.opentelemetry.proto.metrics.v1.AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
    }

    private boolean isDelta() {
        return this.otlpAggregationTemporality == io.opentelemetry.proto.metrics.v1.AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
    }

    void setDeltaAggregationTimeUnixNano() {
        this.deltaAggregationTimeUnixNano = this.clock.wallTime() / this.config.step().toMillis() * this.config.step().toNanos();
    }

    private long getTimeUnixNano() {
        return this.isCumulative() ? TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime()) : this.deltaAggregationTimeUnixNano;
    }

    private long getStartTimeNanos(Meter meter) {
        return this.isCumulative() ? ((StartTimeAwareMeter)meter).getStartTimeNanos() : this.deltaAggregationTimeUnixNano - this.config.step().toNanos();
    }

    private Metric.Builder getMetricBuilder(Meter.Id id) {
        Metric.Builder builder = Metric.newBuilder().setName(this.getConventionName(id));
        if (id.getBaseUnit() != null) {
            builder.setUnit(id.getBaseUnit());
        }
        if (id.getDescription() != null) {
            builder.setDescription(id.getDescription());
        }
        return builder;
    }

    private Iterable<? extends KeyValue> getTagsForId(Meter.Id id) {
        return id.getTags().stream().map(tag -> OtlpMeterRegistry.createKeyValue(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    static KeyValue createKeyValue(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build();
    }

    Iterable<KeyValue> getResourceAttributes() {
        boolean serviceNameProvided = false;
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.name", "io.micrometer"));
        attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.language", "java"));
        String micrometerCoreVersion = MeterRegistry.class.getPackage().getImplementationVersion();
        if (micrometerCoreVersion != null) {
            attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.version", micrometerCoreVersion));
        }
        for (Map.Entry<String, String> keyValue : this.config.resourceAttributes().entrySet()) {
            if ("service.name".equals(keyValue.getKey())) {
                serviceNameProvided = true;
            }
            attributes.add(OtlpMeterRegistry.createKeyValue(keyValue.getKey(), keyValue.getValue()));
        }
        if (!serviceNameProvided) {
            attributes.add(OtlpMeterRegistry.createKeyValue("service.name", "unknown_service"));
        }
        return attributes;
    }

    static io.micrometer.core.instrument.distribution.Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality) {
        return OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, aggregationTemporality, 0L);
    }

    static io.micrometer.core.instrument.distribution.Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality, long stepMillis) {
        if (distributionStatisticConfig.isPublishingHistogram()) {
            if (AggregationTemporality.isCumulative(aggregationTemporality)) {
                return new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).percentiles(new double[0]).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), true, false);
            }
            if (AggregationTemporality.isDelta(aggregationTemporality) && stepMillis > 0L) {
                return new OtlpStepBucketHistogram(clock, stepMillis, distributionStatisticConfig, true, false);
            }
        }
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, false);
        }
        return NoopHistogram.INSTANCE;
    }
}

