/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;

public class InfluxNamingConvention
implements NamingConvention {
    private final NamingConvention basic;

    public InfluxNamingConvention(NamingConvention basic) {
        this.basic = basic;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.format(name.replace("=", "_"));
    }

    public String tagKey(String key) {
        if (key.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag key in InfluxDB");
        }
        return this.format(key);
    }

    public String tagValue(String value) {
        if (value.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag value in InfluxDB");
        }
        return this.format(value);
    }

    private String format(String name) {
        return this.basic.tagKey(name).replace(",", "\\,").replace(" ", "\\ ").replace("=", "\\=").replace("\"", "\\\"");
    }
}

