/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.lang.Nullable;
import java.util.Map;
import java.util.stream.Collectors;

class DynatraceTimeSeries {
    private final String metricId;
    private final Map<String, String> dimensions;
    private final long time;
    private final double value;

    DynatraceTimeSeries(String metricId, long time, double value, @Nullable Map<String, String> dimensions) {
        this.metricId = metricId;
        this.dimensions = dimensions;
        this.time = time;
        this.value = value;
    }

    public String getMetricId() {
        return this.metricId;
    }

    String asJson() {
        String body = "{\"timeseriesId\":\"" + this.metricId + "\",\"dataPoints\":[[" + this.time + "," + DoubleFormat.decimalOrWhole((double)this.value) + "]]";
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            body = body + ",\"dimensions\":{" + this.dimensions.entrySet().stream().map(t -> "\"" + (String)t.getKey() + "\":\"" + (String)t.getValue() + "\"").collect(Collectors.joining(",")) + "}";
        }
        body = body + "}";
        return body;
    }
}

