/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.lang.Nullable;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMetricMetadata;
import io.micrometer.datadog.DatadogNamingConvention;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogMeterRegistry
extends StepMeterRegistry {
    private final URL postTimeSeriesEndpoint;
    private final Logger logger = LoggerFactory.getLogger(DatadogMeterRegistry.class);
    private final DatadogConfig config;
    private final Set<String> verifiedMetadata = ConcurrentHashMap.newKeySet();

    public DatadogMeterRegistry(DatadogConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public DatadogMeterRegistry(DatadogConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        Objects.requireNonNull(config.apiKey());
        this.config().namingConvention((NamingConvention)new DatadogNamingConvention());
        try {
            this.postTimeSeriesEndpoint = URI.create(config.uri() + "/api/v1/series?api_key=" + config.apiKey()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.config = config;
        if (config.enabled()) {
            this.start(threadFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        HashMap<String, DatadogMetricMetadata> metadataToSend = new HashMap<String, DatadogMetricMetadata>();
        try {
            HttpURLConnection con = null;
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                try {
                    con = (HttpURLConnection)this.postTimeSeriesEndpoint.openConnection();
                    con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                    con.setReadTimeout((int)this.config.readTimeout().toMillis());
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "application/json");
                    con.setDoOutput(true);
                    String body = "{\"series\":[" + batch.stream().flatMap(m -> {
                        if (m instanceof Timer) {
                            return this.writeTimer((Timer)m, (Map<String, DatadogMetricMetadata>)metadataToSend);
                        }
                        if (m instanceof DistributionSummary) {
                            return this.writeSummary((DistributionSummary)m, metadataToSend);
                        }
                        if (m instanceof FunctionTimer) {
                            return this.writeTimer((FunctionTimer)m, (Map<String, DatadogMetricMetadata>)metadataToSend);
                        }
                        return this.writeMeter((Meter)m, (Map<String, DatadogMetricMetadata>)metadataToSend);
                    }).collect(Collectors.joining(",")) + "]}";
                    try (OutputStream os = con.getOutputStream();){
                        os.write(body.getBytes());
                        os.flush();
                    }
                    int status = con.getResponseCode();
                    if (status >= 200 && status < 300) {
                        this.logger.info("successfully sent " + batch.size() + " metrics to datadog");
                        continue;
                    }
                    if (status >= 400) {
                        InputStream in = con.getErrorStream();
                        Throwable throwable = null;
                        try {
                            this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                            continue;
                        }
                    }
                    this.logger.error("failed to send metrics: http " + status);
                }
                finally {
                    this.quietlyCloseUrlConnection(con);
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("failed to send metrics", e);
        }
        metadataToSend.forEach(this::postMetricMetadata);
    }

    private void quietlyCloseUrlConnection(@Nullable HttpURLConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Stream<String> writeTimer(FunctionTimer timer, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL_TIME, null);
        return Stream.of(this.writeMetric(id, "count", wallTime, timer.count()), this.writeMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit())), this.writeMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    private Stream<String> writeTimer(Timer timer, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, snapshot.total(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(id, "count", wallTime, snapshot.count()));
        metrics.add(this.writeMetric(id, "avg", wallTime, snapshot.mean(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(id, "max", wallTime, snapshot.max(this.getBaseTimeUnit())));
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL_TIME, null);
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "max", Statistic.MAX, null);
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, snapshot.total()));
        metrics.add(this.writeMetric(id, "count", wallTime, snapshot.count()));
        metrics.add(this.writeMetric(id, "avg", wallTime, snapshot.mean()));
        metrics.add(this.writeMetric(id, "max", wallTime, snapshot.max()));
        this.addToMetadataList(metadata, id, "sum", Statistic.TOTAL, null);
        this.addToMetadataList(metadata, id, "count", Statistic.COUNT, "occurrence");
        this.addToMetadataList(metadata, id, "avg", Statistic.VALUE, null);
        this.addToMetadataList(metadata, id, "max", Statistic.MAX, null);
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter m, Map<String, DatadogMetricMetadata> metadata) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> {
            Meter.Id id = m.getId().withTag(ms.getStatistic());
            this.addToMetadataList(metadata, id, null, ms.getStatistic(), null);
            return this.writeMetric(id, null, wallTime, ms.getValue());
        });
    }

    private void addToMetadataList(Map<String, DatadogMetricMetadata> metadata, Meter.Id id, @Nullable String suffix, Statistic stat, @Nullable String overrideBaseUnit) {
        String metricName;
        if (this.config.applicationKey() == null) {
            return;
        }
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        if (!this.verifiedMetadata.contains(metricName = this.getConventionName(fullId))) {
            metadata.put(metricName, new DatadogMetricMetadata(fullId, stat, this.config.descriptions(), overrideBaseUnit));
        }
    }

    String writeMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        List tags = fullId.getTags();
        String host = this.config.hostTag() == null ? "" : StreamSupport.stream(tags.spliterator(), false).filter(t -> Objects.requireNonNull(this.config.hostTag()).equals(t.getKey())).findAny().map(t -> ",\"host\":\"" + t.getValue() + "\"").orElse("");
        String tagsArray = tags.iterator().hasNext() ? ",\"tags\":[" + StreamSupport.stream(tags.spliterator(), false).map(t -> "\"" + t.getKey() + ":" + t.getValue() + "\"").collect(Collectors.joining(",")) + "]" : "";
        return "{\"metric\":\"" + this.getConventionName(fullId) + "\",\"points\":[[" + wallTime / 1000L + ", " + value + "]]" + host + tagsArray + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postMetricMetadata(String metricName, DatadogMetricMetadata metadata) {
        if (this.verifiedMetadata.contains(metricName)) {
            return;
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)URI.create(this.config.uri() + "/api/v1/metrics/" + URLEncoder.encode(metricName, "UTF-8") + "?api_key=" + this.config.apiKey() + "&application_key=" + this.config.applicationKey()).toURL().openConnection();
            con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
            con.setReadTimeout((int)this.config.readTimeout().toMillis());
            con.setRequestMethod("PUT");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            try (OutputStream os = con.getOutputStream();){
                os.write(metadata.editMetadataBody().getBytes());
                os.flush();
            }
            int status = con.getResponseCode();
            if (status >= 200 && status < 300) {
                this.verifiedMetadata.add(metricName);
            } else if (status >= 400) {
                try (InputStream in = con.getErrorStream();){
                    String msg = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n"));
                    if (msg.contains("metric_name not found")) {
                    }
                    this.logger.error("failed to send metric metadata: " + msg);
                }
            } else {
                this.logger.error("failed to send metric metadata: http " + status);
            }
            this.quietlyCloseUrlConnection(con);
        }
        catch (IOException e) {
            this.logger.warn("failed to send metric metadata", (Throwable)e);
        }
        finally {
            this.quietlyCloseUrlConnection(con);
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return new Meter.Id(id.getName() + "." + suffix, (Iterable)id.getTags(), id.getBaseUnit(), id.getDescription(), id.getType());
    }
}

