/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class InvalidObservationException
extends RuntimeException {
    private final Observation.Context context;
    private final List<HistoryElement> history;

    InvalidObservationException(String message, Observation.Context context, List<HistoryElement> history) {
        super(message);
        this.context = context;
        this.history = history;
    }

    public Observation.Context getContext() {
        return this.context;
    }

    public List<HistoryElement> getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.history.stream().map(HistoryElement::toString).collect(Collectors.joining("\n"));
    }

    public static enum EventName {
        START,
        STOP,
        ERROR,
        EVENT,
        SCOPE_OPEN,
        SCOPE_CLOSE,
        SCOPE_RESET;

    }

    public static class HistoryElement {
        private final EventName eventName;
        private final StackTraceElement[] stackTrace;

        HistoryElement(EventName eventName) {
            this.eventName = eventName;
            StackTraceElement[] currentStackTrace = Thread.getAllStackTraces().get(Thread.currentThread());
            this.stackTrace = this.findRelevantStackTraceElements(currentStackTrace);
        }

        private StackTraceElement[] findRelevantStackTraceElements(StackTraceElement[] stackTrace) {
            int index = this.findFirstRelevantStackTraceElementIndex(stackTrace);
            if (index == -1) {
                return new StackTraceElement[0];
            }
            return Arrays.copyOfRange(stackTrace, index, stackTrace.length);
        }

        private int findFirstRelevantStackTraceElementIndex(StackTraceElement[] stackTrace) {
            int index = -1;
            for (int i = 0; i < stackTrace.length; ++i) {
                if (!this.isObservationRelated(stackTrace[i])) continue;
                index = i + 1;
            }
            return index >= stackTrace.length ? -1 : index;
        }

        private boolean isObservationRelated(StackTraceElement stackTraceElement) {
            String className = stackTraceElement.getClassName();
            return className.equals(Observation.class.getName()) || className.equals("io.micrometer.observation.SimpleObservation") || className.startsWith("io.micrometer.observation.SimpleObservation$");
        }

        public EventName getEventName() {
            return this.eventName;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public String toString() {
            return (Object)((Object)this.eventName) + ": " + this.stackTrace[0];
        }
    }
}

