/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.jakarta9.instrument.jms.JmsKeyValues;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationConvention;
import jakarta.jms.Message;

public class DefaultJmsProcessObservationConvention
implements JmsProcessObservationConvention {
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OPERATION_PROCESS = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.OPERATION, (String)"process");

    public String getName() {
        return "jms.message.process";
    }

    public String getContextualName(JmsProcessObservationContext context) {
        return this.destinationName(context).getValue() + " process";
    }

    public KeyValues getLowCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), OPERATION_PROCESS, this.temporaryDestination(context)});
    }

    private KeyValue exception(JmsProcessObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(!simpleName.isEmpty() ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue temporaryDestination(JmsProcessObservationContext context) {
        return JmsKeyValues.temporaryDestination((Message)context.getCarrier());
    }

    public KeyValues getHighCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.correlationId(context), this.destinationName(context), this.messageId(context)});
    }

    protected KeyValue correlationId(JmsProcessObservationContext context) {
        return JmsKeyValues.conversationId((Message)context.getCarrier());
    }

    protected KeyValue destinationName(JmsProcessObservationContext context) {
        return JmsKeyValues.destinationName((Message)context.getCarrier());
    }

    protected KeyValue messageId(JmsProcessObservationContext context) {
        return JmsKeyValues.messageId((Message)context.getCarrier());
    }
}

